/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.testcontainers;

import java.io.IOException;
import java.net.ServerSocket;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class LocalS3Container
extends GenericContainer<LocalS3Container> {
    public static final String IMAGE_NAME = "luofuxiang/local-s3";
    public static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"luofuxiang/local-s3");
    private int port;
    private String dataPath;
    private Mode mode;

    LocalS3Container(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)"^.{1,}LocalS3 started.\n$", (int)1));
    }

    public LocalS3Container(String tag) {
        this(DockerImageName.parse((String)IMAGE_NAME).withTag(tag));
    }

    public LocalS3Container withHttpPort(int port) {
        this.port = port;
        super.addFixedExposedPort(port, 80);
        return this;
    }

    public LocalS3Container withRandomHttpPort() {
        return this.withHttpPort(this.findFreeTcpPort());
    }

    public LocalS3Container withDataPath(String path) {
        return (LocalS3Container)super.withFileSystemBind(path, "/data");
    }

    public LocalS3Container withMode(Mode mode) {
        return (LocalS3Container)super.withEnv("MODE", mode.name());
    }

    public int getPort() {
        return this.port;
    }

    private int findFreeTcpPort() {
        int freePort;
        try (ServerSocket serverSocket = new ServerSocket(0);){
            freePort = serverSocket.getLocalPort();
        }
        catch (IOException e) {
            throw new IllegalStateException("TCP port is not available.");
        }
        return freePort;
    }

    public static enum Mode {
        PERSISTENCE,
        IN_MEMORY;

    }
}

