/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.model.Bucket;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.datatypes.response.LocationConstraint;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;

class GetBucketLocationController
implements HttpRequestHandler {
    private final XmlMapper xmlMapper;
    private final BucketService bucketService;

    public GetBucketLocationController(ServiceFactory serviceFactory) {
        this.xmlMapper = serviceFactory.getInstance(XmlMapper.class);
        this.bucketService = serviceFactory.getInstance(BucketService.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        Bucket bucket = this.bucketService.getBucket(bucketName);
        LocationConstraint locationConstraint = LocationConstraint.builder().locationConstraint(bucket.getRegion().orElse("local")).build();
        response.write(this.xmlMapper.writeValueAsString((Object)locationConstraint));
        ResponseUtils.addCommonHeaders(response);
    }
}

