/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.service.BucketEncryptionService;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.HttpResponseStatus;

class BucketEncryptionController {
    private final BucketEncryptionService encryptionService;

    BucketEncryptionController(ServiceFactory serviceFactory) {
        this.encryptionService = (BucketEncryptionService)serviceFactory.getInstance(BucketService.class);
    }

    void put(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        try (ByteBufInputStream in = new ByteBufInputStream(request.getBody());){
            this.encryptionService.putBucketEncryption(bucketName, new String(in.readAllBytes()));
        }
        ResponseUtils.addCommonHeaders(response).status(HttpResponseStatus.OK);
    }

    void get(HttpRequest request, HttpResponse response) {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        String encryption = this.encryptionService.getBucketEncryption(bucketName);
        ResponseUtils.addCommonHeaders(response).write(encryption).status(HttpResponseStatus.OK);
    }

    void delete(HttpRequest request, HttpResponse response) {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        this.encryptionService.deleteBucketEncryption(bucketName);
        ResponseUtils.addCommonHeaders(response).status(HttpResponseStatus.NO_CONTENT);
    }
}

