/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.timelimiter.configure;

import io.github.resilience4j.reactor.timelimiter.TimeLimiterOperator;
import io.github.resilience4j.spring6.timelimiter.configure.IllegalReturnTypeException;
import io.github.resilience4j.spring6.timelimiter.configure.TimeLimiterAspectExt;
import io.github.resilience4j.timelimiter.TimeLimiter;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorTimeLimiterAspectExt
implements TimeLimiterAspectExt {
    @Override
    public boolean canHandleReturnType(Class<?> returnType) {
        return Flux.class.isAssignableFrom(returnType) || Mono.class.isAssignableFrom(returnType);
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, TimeLimiter timeLimiter, String methodName) throws Throwable {
        Object returnValue = proceedingJoinPoint.proceed();
        if (Flux.class.isAssignableFrom(returnValue.getClass())) {
            Flux fluxReturnValue = (Flux)returnValue;
            return fluxReturnValue.transformDeferred((Function)TimeLimiterOperator.of((TimeLimiter)timeLimiter));
        }
        if (Mono.class.isAssignableFrom(returnValue.getClass())) {
            Mono monoReturnValue = (Mono)returnValue;
            return monoReturnValue.transformDeferred((Function)TimeLimiterOperator.of((TimeLimiter)timeLimiter));
        }
        throw new IllegalReturnTypeException(returnValue.getClass(), methodName, "Reactor expects Mono/Flux.");
    }
}

