/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.fallback;

import io.github.resilience4j.core.functions.CheckedSupplier;
import io.github.resilience4j.fallback.FallbackDecorator;
import io.github.resilience4j.fallback.FallbackMethod;
import io.github.resilience4j.utils.AspectUtil;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.util.Set;
import java.util.function.Function;

public class RxJava2FallbackDecorator
implements FallbackDecorator {
    private static final Set<Class<?>> RX_SUPPORTED_TYPES = AspectUtil.newHashSet(ObservableSource.class, SingleSource.class, CompletableSource.class, MaybeSource.class, Flowable.class);

    @Override
    public boolean supports(Class<?> target) {
        return RX_SUPPORTED_TYPES.stream().anyMatch(it -> it.isAssignableFrom(target));
    }

    @Override
    public CheckedSupplier<Object> decorate(FallbackMethod fallbackMethod, CheckedSupplier<Object> supplier) {
        return supplier.andThen(request -> {
            if (request instanceof ObservableSource) {
                Observable observable = (Observable)request;
                return observable.onErrorResumeNext(this.rxJava2OnErrorResumeNext(fallbackMethod, Observable::error));
            }
            if (request instanceof SingleSource) {
                Single single = (Single)request;
                return single.onErrorResumeNext(this.rxJava2OnErrorResumeNext(fallbackMethod, Single::error));
            }
            if (request instanceof CompletableSource) {
                Completable completable = (Completable)request;
                return completable.onErrorResumeNext(this.rxJava2OnErrorResumeNext(fallbackMethod, Completable::error));
            }
            if (request instanceof MaybeSource) {
                Maybe maybe = (Maybe)request;
                return maybe.onErrorResumeNext(this.rxJava2OnErrorResumeNext(fallbackMethod, Maybe::error));
            }
            if (request instanceof Flowable) {
                Flowable flowable = (Flowable)request;
                return flowable.onErrorResumeNext(this.rxJava2OnErrorResumeNext(fallbackMethod, Flowable::error));
            }
            return request;
        });
    }

    private <T> io.reactivex.functions.Function<Throwable, T> rxJava2OnErrorResumeNext(FallbackMethod fallbackMethod, Function<? super Throwable, ? extends T> errorFunction) {
        return throwable -> {
            try {
                return fallbackMethod.fallback((Throwable)throwable);
            }
            catch (Throwable fallbackThrowable) {
                return errorFunction.apply(fallbackThrowable);
            }
        };
    }
}

