/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.ratelimiter.autoconfigure;

import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.springboot3.fallback.autoconfigure.FallbackConfigurationOnMissingBean;
import io.github.resilience4j.springboot3.ratelimiter.autoconfigure.RateLimiterConfigurationOnMissingBean;
import io.github.resilience4j.springboot3.ratelimiter.autoconfigure.RateLimiterProperties;
import io.github.resilience4j.springboot3.ratelimiter.monitoring.endpoint.RateLimiterEndpoint;
import io.github.resilience4j.springboot3.ratelimiter.monitoring.endpoint.RateLimiterEventsEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={RateLimiter.class})
@EnableConfigurationProperties(value={RateLimiterProperties.class})
@Import(value={RateLimiterConfigurationOnMissingBean.class, FallbackConfigurationOnMissingBean.class})
public class RateLimiterAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    static class RateLimiterEndpointAutoConfiguration {
        RateLimiterEndpointAutoConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        public RateLimiterEndpoint rateLimiterEndpoint(RateLimiterRegistry rateLimiterRegistry) {
            return new RateLimiterEndpoint(rateLimiterRegistry);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        public RateLimiterEventsEndpoint rateLimiterEventsEndpoint(EventConsumerRegistry<RateLimiterEvent> eventConsumerRegistry) {
            return new RateLimiterEventsEndpoint(eventConsumerRegistry);
        }
    }
}

