/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.micrometer.autoconfigure;

import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.micrometer.TimerRegistry;
import io.github.resilience4j.micrometer.event.TimerEvent;
import io.github.resilience4j.springboot3.fallback.autoconfigure.FallbackConfigurationOnMissingBean;
import io.github.resilience4j.springboot3.micrometer.autoconfigure.TimerConfigurationOnMissingBean;
import io.github.resilience4j.springboot3.micrometer.autoconfigure.TimerProperties;
import io.github.resilience4j.springboot3.micrometer.monitoring.endpoint.TimerEndpoint;
import io.github.resilience4j.springboot3.micrometer.monitoring.endpoint.TimerEventsEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={Timer.class})
@EnableConfigurationProperties(value={TimerProperties.class})
@Import(value={TimerConfigurationOnMissingBean.class, FallbackConfigurationOnMissingBean.class})
public class TimerAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    static class TimerAutoEndpointConfiguration {
        TimerAutoEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        public TimerEndpoint timerEndpoint(TimerRegistry timerRegistry) {
            return new TimerEndpoint(timerRegistry);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        public TimerEventsEndpoint timerEventsEndpoint(EventConsumerRegistry<TimerEvent> eventConsumerRegistry) {
            return new TimerEventsEndpoint(eventConsumerRegistry);
        }
    }
}

