/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.internal;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.micrometer.TimerConfig;
import io.github.resilience4j.micrometer.TimerRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class InMemoryTimerRegistry
extends AbstractRegistry<Timer, TimerConfig>
implements TimerRegistry {
    private MeterRegistry meterRegistry;

    public InMemoryTimerRegistry(Map<String, TimerConfig> configs, List<RegistryEventConsumer<Timer>> registryEventConsumers, Map<String, String> tags, MeterRegistry meterRegistry) {
        this(configs.getOrDefault("default", TimerConfig.ofDefaults()), configs, registryEventConsumers, tags, meterRegistry);
    }

    public InMemoryTimerRegistry(TimerConfig defaultConfig, Map<String, TimerConfig> configs, List<RegistryEventConsumer<Timer>> registryEventConsumers, Map<String, String> tags, MeterRegistry meterRegistry) {
        super((Object)defaultConfig, registryEventConsumers, tags);
        Objects.requireNonNullElse(configs, Collections.emptyMap()).entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("default")).forEach(entry -> this.addConfiguration((String)entry.getKey(), (TimerConfig)entry.getValue()));
        this.meterRegistry = meterRegistry;
    }

    @Override
    public Stream<Timer> getAllTimers() {
        return this.entryMap.values().stream();
    }

    @Override
    public Timer timer(String name) {
        return this.timer(name, (TimerConfig)this.getDefaultConfig(), Collections.emptyMap());
    }

    @Override
    public Timer timer(String name, Map<String, String> tags) {
        return this.timer(name, (TimerConfig)this.getDefaultConfig(), tags);
    }

    @Override
    public Timer timer(String name, TimerConfig config) {
        return this.timer(name, config, Collections.emptyMap());
    }

    @Override
    public Timer timer(String name, TimerConfig timerConfig, Map<String, String> tags) {
        return (Timer)this.computeIfAbsent(name, () -> Timer.of(name, this.meterRegistry, timerConfig, this.getAllTags(tags)));
    }

    @Override
    public Timer timer(String name, Supplier<TimerConfig> timerConfigSupplier) {
        return this.timer(name, timerConfigSupplier, Collections.emptyMap());
    }

    @Override
    public Timer timer(String name, Supplier<TimerConfig> timerConfigSupplier, Map<String, String> tags) {
        return (Timer)this.computeIfAbsent(name, () -> Timer.of(name, this.meterRegistry, (TimerConfig)timerConfigSupplier.get(), this.getAllTags(tags)));
    }

    @Override
    public Timer timer(String name, String configName) {
        return this.timer(name, configName, Collections.emptyMap());
    }

    @Override
    public Timer timer(String name, String configName, Map<String, String> tags) {
        TimerConfig config = (TimerConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName));
        return this.timer(name, config, tags);
    }
}

