/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.micrometer.monitoring.endpoint;

import io.github.resilience4j.common.micrometer.monitoring.endpoint.TimerEventDTO;
import io.github.resilience4j.micrometer.event.TimerEvent;
import io.github.resilience4j.micrometer.event.TimerOnFailureEvent;
import io.github.resilience4j.micrometer.event.TimerOnStartEvent;
import io.github.resilience4j.micrometer.event.TimerOnSuccessEvent;

public class TimerEventDTOFactory {
    private TimerEventDTOFactory() {
    }

    public static TimerEventDTO createTimerEventDTO(TimerEvent event) {
        switch (event.getEventType()) {
            case START: {
                TimerOnStartEvent onStartEvent = (TimerOnStartEvent)event;
                return new TimerEventDTO(onStartEvent.getTimerName(), onStartEvent.getEventType(), onStartEvent.getCreationTime().toString());
            }
            case SUCCESS: {
                TimerOnSuccessEvent onSuccessEvent = (TimerOnSuccessEvent)event;
                return new TimerEventDTO(onSuccessEvent.getTimerName(), onSuccessEvent.getEventType(), onSuccessEvent.getCreationTime().toString(), onSuccessEvent.getOperationDuration());
            }
            case FAILURE: {
                TimerOnFailureEvent onFailureEvent = (TimerOnFailureEvent)event;
                return new TimerEventDTO(onFailureEvent.getTimerName(), onFailureEvent.getEventType(), onFailureEvent.getCreationTime().toString(), onFailureEvent.getOperationDuration());
            }
        }
        throw new IllegalArgumentException("Invalid event");
    }
}

