/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.circuitbreaker.configuration;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.common.CommonProperties;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.circuitbreaker.configuration.CircuitBreakerConfigCustomizer;
import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ClassUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CommonCircuitBreakerConfigurationProperties
extends CommonProperties {
    private static final String DEFAULT = "default";
    private Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public Optional<InstanceProperties> findCircuitBreakerProperties(String name) {
        InstanceProperties instanceProperties = this.instances.get(name);
        if (instanceProperties == null) {
            instanceProperties = this.configs.get(DEFAULT);
        } else if (this.configs.get(DEFAULT) != null) {
            ConfigUtils.mergePropertiesIfAny(instanceProperties, this.configs.get(DEFAULT));
        }
        return Optional.ofNullable(instanceProperties);
    }

    public CircuitBreakerConfig createCircuitBreakerConfig(String instanceName, @Nullable InstanceProperties instanceProperties, CompositeCustomizer<CircuitBreakerConfigCustomizer> customizer) {
        CircuitBreakerConfig baseConfig = null;
        if (instanceProperties != null && StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            baseConfig = this.createBaseConfig(instanceName, instanceProperties, customizer);
        } else if (this.configs.get(instanceName) != null) {
            baseConfig = this.createDirectConfig(instanceName, instanceProperties, customizer);
        } else if (this.configs.get(DEFAULT) != null) {
            baseConfig = this.createDefaultConfig(instanceProperties, customizer);
        }
        return this.buildConfig(baseConfig != null ? CircuitBreakerConfig.from((CircuitBreakerConfig)baseConfig) : CircuitBreakerConfig.custom(), instanceProperties, customizer, instanceName);
    }

    private CircuitBreakerConfig createBaseConfig(String instanceName, InstanceProperties instanceProperties, CompositeCustomizer<CircuitBreakerConfigCustomizer> customizer) {
        String baseConfigName = instanceProperties.getBaseConfig();
        if (instanceName.equals(baseConfigName)) {
            throw new IllegalStateException("Circular reference detected in instance config: " + instanceName);
        }
        InstanceProperties baseProperties = this.configs.get(baseConfigName);
        if (baseProperties == null) {
            throw new ConfigurationNotFoundException(baseConfigName);
        }
        ConfigUtils.mergePropertiesIfAny(instanceProperties, baseProperties);
        return this.createCircuitBreakerConfig(baseConfigName, baseProperties, customizer);
    }

    private CircuitBreakerConfig createDirectConfig(String instanceName, @Nullable InstanceProperties instanceProperties, CompositeCustomizer<CircuitBreakerConfigCustomizer> customizer) {
        if (instanceProperties != null) {
            ConfigUtils.mergePropertiesIfAny(instanceProperties, this.configs.get(instanceName));
        }
        return this.buildConfig(CircuitBreakerConfig.custom(), this.configs.get(instanceName), customizer, instanceName);
    }

    private CircuitBreakerConfig createDefaultConfig(@Nullable InstanceProperties instanceProperties, CompositeCustomizer<CircuitBreakerConfigCustomizer> customizer) {
        if (instanceProperties != null) {
            ConfigUtils.mergePropertiesIfAny(instanceProperties, this.configs.get(DEFAULT));
        }
        return this.createCircuitBreakerConfig(DEFAULT, this.configs.get(DEFAULT), customizer);
    }

    private CircuitBreakerConfig buildConfig(CircuitBreakerConfig.Builder builder, @Nullable InstanceProperties properties, CompositeCustomizer<CircuitBreakerConfigCustomizer> compositeCircuitBreakerCustomizer, String instanceName) {
        if (properties != null) {
            if (properties.enableExponentialBackoff != null && properties.enableExponentialBackoff.booleanValue() && properties.enableRandomizedWait != null && properties.enableRandomizedWait.booleanValue()) {
                throw new IllegalStateException("you can not enable Exponential backoff policy and randomized delay at the same time , please enable only one of them");
            }
            this.configureCircuitBreakerOpenStateIntervalFunction(properties, builder);
            if (properties.getFailureRateThreshold() != null) {
                builder.failureRateThreshold(properties.getFailureRateThreshold().floatValue());
            }
            if (properties.getWritableStackTraceEnabled() != null) {
                builder.writableStackTraceEnabled(properties.getWritableStackTraceEnabled().booleanValue());
            }
            if (properties.getSlowCallRateThreshold() != null) {
                builder.slowCallRateThreshold(properties.getSlowCallRateThreshold().floatValue());
            }
            if (properties.getSlowCallDurationThreshold() != null) {
                builder.slowCallDurationThreshold(properties.getSlowCallDurationThreshold());
            }
            if (properties.getMaxWaitDurationInHalfOpenState() != null) {
                builder.maxWaitDurationInHalfOpenState(properties.getMaxWaitDurationInHalfOpenState());
            }
            if (properties.getSlidingWindowSize() != null) {
                builder.slidingWindowSize(properties.getSlidingWindowSize().intValue());
            }
            if (properties.getMinimumNumberOfCalls() != null) {
                builder.minimumNumberOfCalls(properties.getMinimumNumberOfCalls().intValue());
            }
            if (properties.getSlidingWindowType() != null) {
                builder.slidingWindowType(properties.getSlidingWindowType());
            }
            if (properties.getPermittedNumberOfCallsInHalfOpenState() != null) {
                builder.permittedNumberOfCallsInHalfOpenState(properties.getPermittedNumberOfCallsInHalfOpenState().intValue());
            }
            if (properties.recordExceptions != null) {
                builder.recordExceptions((Class[])properties.recordExceptions);
                builder.recordException(null);
            }
            if (properties.recordFailurePredicate != null) {
                this.buildRecordFailurePredicate(properties, builder);
            }
            if (properties.recordResultPredicate != null) {
                this.buildRecordResultPredicate(properties, builder);
            }
            if (properties.ignoreExceptions != null) {
                builder.ignoreExceptions((Class[])properties.ignoreExceptions);
                builder.ignoreException(null);
            }
            if (properties.ignoreExceptionPredicate != null) {
                this.buildIgnoreExceptionPredicate(properties, builder);
            }
            if (properties.automaticTransitionFromOpenToHalfOpenEnabled != null) {
                builder.automaticTransitionFromOpenToHalfOpenEnabled(properties.automaticTransitionFromOpenToHalfOpenEnabled.booleanValue());
            }
        }
        compositeCircuitBreakerCustomizer.getCustomizer(instanceName).ifPresent(circuitBreakerConfigCustomizer -> circuitBreakerConfigCustomizer.customize(builder));
        return builder.build();
    }

    private void configureCircuitBreakerOpenStateIntervalFunction(InstanceProperties properties, CircuitBreakerConfig.Builder builder) {
        Duration waitDurationInOpenState = properties.getWaitDurationInOpenState();
        if (waitDurationInOpenState != null && waitDurationInOpenState.toMillis() > 0L) {
            if (properties.getEnableExponentialBackoff() != null && properties.getEnableExponentialBackoff().booleanValue()) {
                this.configureEnableExponentialBackoff(properties, builder);
            } else if (properties.getEnableRandomizedWait() != null && properties.getEnableRandomizedWait().booleanValue()) {
                this.configureEnableRandomizedWait(properties, builder);
            } else {
                builder.waitDurationInOpenState(waitDurationInOpenState);
            }
        }
    }

    private void configureEnableExponentialBackoff(InstanceProperties properties, CircuitBreakerConfig.Builder builder) {
        Duration maxWaitDuration = properties.getExponentialMaxWaitDurationInOpenState();
        Double backoffMultiplier = properties.getExponentialBackoffMultiplier();
        Duration waitDuration = properties.getWaitDurationInOpenState();
        if (maxWaitDuration != null && backoffMultiplier != null) {
            builder.waitIntervalFunctionInOpenState(IntervalFunction.ofExponentialBackoff((Duration)waitDuration, (double)backoffMultiplier, (Duration)maxWaitDuration));
        } else if (backoffMultiplier != null) {
            builder.waitIntervalFunctionInOpenState(IntervalFunction.ofExponentialBackoff((Duration)waitDuration, (double)backoffMultiplier));
        } else {
            builder.waitIntervalFunctionInOpenState(IntervalFunction.ofExponentialBackoff((Duration)waitDuration));
        }
    }

    private void configureEnableRandomizedWait(InstanceProperties properties, CircuitBreakerConfig.Builder builder) {
        Duration waitDuration = properties.getWaitDurationInOpenState();
        if (properties.getRandomizedWaitFactor() != null) {
            builder.waitIntervalFunctionInOpenState(IntervalFunction.ofRandomized((Duration)waitDuration, (double)properties.getRandomizedWaitFactor()));
        } else {
            builder.waitIntervalFunctionInOpenState(IntervalFunction.ofRandomized((Duration)waitDuration));
        }
    }

    private void buildRecordFailurePredicate(InstanceProperties properties, CircuitBreakerConfig.Builder builder) {
        Predicate predicate;
        if (properties.getRecordFailurePredicate() != null && (predicate = ClassUtils.instantiatePredicateClass(properties.getRecordFailurePredicate())) != null) {
            builder.recordException(predicate);
        }
    }

    private void buildRecordResultPredicate(InstanceProperties properties, CircuitBreakerConfig.Builder builder) {
        Predicate predicate;
        if (properties.getRecordResultPredicate() != null && (predicate = ClassUtils.instantiatePredicateClass(properties.getRecordResultPredicate())) != null) {
            builder.recordResult(predicate);
        }
    }

    private void buildIgnoreExceptionPredicate(InstanceProperties properties, CircuitBreakerConfig.Builder builder) {
        Predicate predicate;
        if (properties.getIgnoreExceptionPredicate() != null && (predicate = ClassUtils.instantiatePredicateClass(properties.getIgnoreExceptionPredicate())) != null) {
            builder.ignoreException(predicate);
        }
    }

    @Nullable
    public InstanceProperties getBackendProperties(String backend) {
        return this.instances.get(backend);
    }

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getBackends() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    public static class InstanceProperties {
        @Nullable
        private Duration waitDurationInOpenState;
        @Nullable
        private Duration slowCallDurationThreshold;
        @Nullable
        private Duration maxWaitDurationInHalfOpenState;
        @Nullable
        private Float failureRateThreshold;
        @Nullable
        private Float slowCallRateThreshold;
        @Nullable
        private CircuitBreakerConfig.SlidingWindowType slidingWindowType;
        @Nullable
        private Integer slidingWindowSize;
        @Nullable
        private Integer minimumNumberOfCalls;
        @Nullable
        private Integer permittedNumberOfCallsInHalfOpenState;
        @Nullable
        private Boolean automaticTransitionFromOpenToHalfOpenEnabled;
        @Nullable
        private Boolean writableStackTraceEnabled;
        @Nullable
        private Boolean allowHealthIndicatorToFail;
        @Nullable
        private Integer eventConsumerBufferSize;
        @Nullable
        private Boolean registerHealthIndicator;
        @Nullable
        private Class<Predicate<Throwable>> recordFailurePredicate;
        @Nullable
        private Class<? extends Throwable>[] recordExceptions;
        @Nullable
        private Class<Predicate<Object>> recordResultPredicate;
        @Nullable
        private Class<Predicate<Throwable>> ignoreExceptionPredicate;
        @Nullable
        private Class<? extends Throwable>[] ignoreExceptions;
        @Nullable
        private String baseConfig;
        @Nullable
        private Boolean enableExponentialBackoff;
        private Double exponentialBackoffMultiplier;
        private Duration exponentialMaxWaitDurationInOpenState;
        @Nullable
        private Boolean enableRandomizedWait;
        private Double randomizedWaitFactor;
        @Nullable
        private Boolean ignoreClassBindingExceptions;

        @Nullable
        public Float getFailureRateThreshold() {
            return this.failureRateThreshold;
        }

        public InstanceProperties setFailureRateThreshold(Float failureRateThreshold) {
            Objects.requireNonNull(failureRateThreshold);
            if (failureRateThreshold.floatValue() < 1.0f || failureRateThreshold.floatValue() > 100.0f) {
                throw new IllegalArgumentException("failureRateThreshold must be between 1 and 100.");
            }
            this.failureRateThreshold = failureRateThreshold;
            return this;
        }

        @Nullable
        public Duration getWaitDurationInOpenState() {
            return this.waitDurationInOpenState;
        }

        public InstanceProperties setWaitDurationInOpenState(Duration waitDurationInOpenStateMillis) {
            Objects.requireNonNull(waitDurationInOpenStateMillis);
            if (waitDurationInOpenStateMillis.toMillis() < 1L) {
                throw new IllegalArgumentException("waitDurationInOpenStateMillis must be greater than or equal to 1 millis.");
            }
            this.waitDurationInOpenState = waitDurationInOpenStateMillis;
            return this;
        }

        public Boolean getAutomaticTransitionFromOpenToHalfOpenEnabled() {
            return this.automaticTransitionFromOpenToHalfOpenEnabled;
        }

        public InstanceProperties setAutomaticTransitionFromOpenToHalfOpenEnabled(Boolean automaticTransitionFromOpenToHalfOpenEnabled) {
            this.automaticTransitionFromOpenToHalfOpenEnabled = automaticTransitionFromOpenToHalfOpenEnabled;
            return this;
        }

        @Nullable
        public Boolean getWritableStackTraceEnabled() {
            return this.writableStackTraceEnabled;
        }

        public InstanceProperties setWritableStackTraceEnabled(Boolean writableStackTraceEnabled) {
            this.writableStackTraceEnabled = writableStackTraceEnabled;
            return this;
        }

        @Nullable
        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            Objects.requireNonNull(eventConsumerBufferSize);
            if (eventConsumerBufferSize < 1) {
                throw new IllegalArgumentException("eventConsumerBufferSize must be greater than or equal to 1.");
            }
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        @Nullable
        public Boolean getAllowHealthIndicatorToFail() {
            return this.allowHealthIndicatorToFail;
        }

        public InstanceProperties setAllowHealthIndicatorToFail(Boolean allowHealthIndicatorToFail) {
            this.allowHealthIndicatorToFail = allowHealthIndicatorToFail;
            return this;
        }

        @Nullable
        public Boolean getRegisterHealthIndicator() {
            return this.registerHealthIndicator;
        }

        public InstanceProperties setRegisterHealthIndicator(Boolean registerHealthIndicator) {
            this.registerHealthIndicator = registerHealthIndicator;
            return this;
        }

        @Nullable
        public Class<Predicate<Throwable>> getRecordFailurePredicate() {
            return this.recordFailurePredicate;
        }

        public InstanceProperties setRecordFailurePredicate(Class<Predicate<Throwable>> recordFailurePredicate) {
            this.recordFailurePredicate = recordFailurePredicate;
            return this;
        }

        @Nullable
        public Class<Predicate<Object>> getRecordResultPredicate() {
            return this.recordResultPredicate;
        }

        public InstanceProperties setRecordResultPredicate(Class<Predicate<Object>> recordResultPredicate) {
            this.recordResultPredicate = recordResultPredicate;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getRecordExceptions() {
            return this.recordExceptions;
        }

        public InstanceProperties setRecordExceptions(Class<? extends Throwable>[] recordExceptions) {
            this.recordExceptions = recordExceptions;
            return this;
        }

        @Nullable
        public Class<Predicate<Throwable>> getIgnoreExceptionPredicate() {
            return this.ignoreExceptionPredicate;
        }

        public InstanceProperties setIgnoreExceptionPredicate(Class<Predicate<Throwable>> ignoreExceptionPredicate) {
            this.ignoreExceptionPredicate = ignoreExceptionPredicate;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public InstanceProperties setIgnoreExceptions(Class<? extends Throwable>[] ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }

        @Nullable
        public Integer getPermittedNumberOfCallsInHalfOpenState() {
            return this.permittedNumberOfCallsInHalfOpenState;
        }

        public InstanceProperties setPermittedNumberOfCallsInHalfOpenState(Integer permittedNumberOfCallsInHalfOpenState) {
            Objects.requireNonNull(permittedNumberOfCallsInHalfOpenState);
            if (permittedNumberOfCallsInHalfOpenState < 1) {
                throw new IllegalArgumentException("permittedNumberOfCallsInHalfOpenState must be greater than or equal to 1.");
            }
            this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
            return this;
        }

        @Nullable
        public Integer getMinimumNumberOfCalls() {
            return this.minimumNumberOfCalls;
        }

        public InstanceProperties setMinimumNumberOfCalls(Integer minimumNumberOfCalls) {
            Objects.requireNonNull(minimumNumberOfCalls);
            if (minimumNumberOfCalls < 1) {
                throw new IllegalArgumentException("minimumNumberOfCalls must be greater than or equal to 1.");
            }
            this.minimumNumberOfCalls = minimumNumberOfCalls;
            return this;
        }

        @Nullable
        public Integer getSlidingWindowSize() {
            return this.slidingWindowSize;
        }

        public InstanceProperties setSlidingWindowSize(Integer slidingWindowSize) {
            Objects.requireNonNull(slidingWindowSize);
            if (slidingWindowSize < 1) {
                throw new IllegalArgumentException("slidingWindowSize must be greater than or equal to 1.");
            }
            this.slidingWindowSize = slidingWindowSize;
            return this;
        }

        @Nullable
        public Float getSlowCallRateThreshold() {
            return this.slowCallRateThreshold;
        }

        public InstanceProperties setSlowCallRateThreshold(Float slowCallRateThreshold) {
            Objects.requireNonNull(slowCallRateThreshold);
            if (slowCallRateThreshold.floatValue() < 1.0f || slowCallRateThreshold.floatValue() > 100.0f) {
                throw new IllegalArgumentException("slowCallRateThreshold must be between 1 and 100.");
            }
            this.slowCallRateThreshold = slowCallRateThreshold;
            return this;
        }

        @Nullable
        public Duration getSlowCallDurationThreshold() {
            return this.slowCallDurationThreshold;
        }

        @Nullable
        public Duration getMaxWaitDurationInHalfOpenState() {
            return this.maxWaitDurationInHalfOpenState;
        }

        public InstanceProperties setSlowCallDurationThreshold(Duration slowCallDurationThreshold) {
            Objects.requireNonNull(slowCallDurationThreshold);
            if (slowCallDurationThreshold.toNanos() < 1L) {
                throw new IllegalArgumentException("slowCallDurationThreshold must be greater than or equal to 1 nanos.");
            }
            this.slowCallDurationThreshold = slowCallDurationThreshold;
            return this;
        }

        public InstanceProperties setMaxWaitDurationInHalfOpenState(Duration maxWaitDurationInHalfOpenState) {
            Objects.requireNonNull(maxWaitDurationInHalfOpenState);
            if (maxWaitDurationInHalfOpenState.toMillis() < 0L) {
                throw new IllegalArgumentException("maxWaitDurationInHalfOpenState must be greater than or equal to 0 ms.");
            }
            this.maxWaitDurationInHalfOpenState = maxWaitDurationInHalfOpenState;
            return this;
        }

        @Nullable
        public CircuitBreakerConfig.SlidingWindowType getSlidingWindowType() {
            return this.slidingWindowType;
        }

        public InstanceProperties setSlidingWindowType(CircuitBreakerConfig.SlidingWindowType slidingWindowType) {
            this.slidingWindowType = slidingWindowType;
            return this;
        }

        public Boolean getEnableExponentialBackoff() {
            return this.enableExponentialBackoff;
        }

        public InstanceProperties setEnableExponentialBackoff(Boolean enableExponentialBackoff) {
            this.enableExponentialBackoff = enableExponentialBackoff;
            return this;
        }

        @Nullable
        public Double getExponentialBackoffMultiplier() {
            return this.exponentialBackoffMultiplier;
        }

        public InstanceProperties setExponentialBackoffMultiplier(Double exponentialBackoffMultiplier) {
            if (exponentialBackoffMultiplier <= 0.0) {
                throw new IllegalArgumentException("Illegal argument exponentialBackoffMultiplier: " + exponentialBackoffMultiplier + " is less or equal 0");
            }
            this.exponentialBackoffMultiplier = exponentialBackoffMultiplier;
            return this;
        }

        @Nullable
        public Duration getExponentialMaxWaitDurationInOpenState() {
            return this.exponentialMaxWaitDurationInOpenState;
        }

        public InstanceProperties setExponentialMaxWaitDurationInOpenState(Duration exponentialMaxWaitDurationInOpenState) {
            if (exponentialMaxWaitDurationInOpenState.toMillis() < 1L) {
                throw new IllegalArgumentException("Illegal argument interval: " + exponentialMaxWaitDurationInOpenState + " is less than 1 millisecond");
            }
            this.exponentialMaxWaitDurationInOpenState = exponentialMaxWaitDurationInOpenState;
            return this;
        }

        @Nullable
        public Boolean getEnableRandomizedWait() {
            return this.enableRandomizedWait;
        }

        public InstanceProperties setEnableRandomizedWait(Boolean enableRandomizedWait) {
            this.enableRandomizedWait = enableRandomizedWait;
            return this;
        }

        @Nullable
        public Double getRandomizedWaitFactor() {
            return this.randomizedWaitFactor;
        }

        public InstanceProperties setRandomizedWaitFactor(Double randomizedWaitFactor) {
            if (randomizedWaitFactor < 0.0 || randomizedWaitFactor >= 1.0) {
                throw new IllegalArgumentException("Illegal argument randomizedWaitFactor: " + randomizedWaitFactor + " is not in range [0..1)");
            }
            this.randomizedWaitFactor = randomizedWaitFactor;
            return this;
        }

        @Nullable
        public Boolean getIgnoreClassBindingExceptions() {
            return this.ignoreClassBindingExceptions;
        }

        public InstanceProperties setIgnoreClassBindingExceptions(Boolean ignoreClassBindingExceptions) {
            this.ignoreClassBindingExceptions = ignoreClassBindingExceptions;
            return this;
        }
    }
}

