/*
 * Decompiled with CFR 0.152.
 */
package redis.protocol;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.util.ByteString;
import redis.protocol.Bulk;
import redis.protocol.DecodeResult;
import redis.protocol.Error;
import redis.protocol.FullyDecoded;
import redis.protocol.Integer;
import redis.protocol.MultiBulk;
import redis.protocol.PartiallyDecoded;
import redis.protocol.RedisReply;
import redis.protocol.Status;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ReusableBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class RedisProtocolReply$ {
    public static final RedisProtocolReply$ MODULE$ = new RedisProtocolReply$();
    private static final char ERROR = (char)45;
    private static final char STATUS = (char)43;
    private static final char INTEGER = (char)58;
    private static final char BULK = (char)36;
    private static final char MULTIBULK = (char)42;
    private static final byte[] LS = "\r\n".getBytes("UTF-8");
    private static final PartialFunction<ByteString, DecodeResult<RedisReply>> decodeReplyPF = new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
            A1 A1 = x1;
            if (A1.head() == RedisProtocolReply$.MODULE$.INTEGER()) {
                return (B1)RedisProtocolReply$.MODULE$.decodeInteger(A1.tail());
            }
            if (A1.head() == RedisProtocolReply$.MODULE$.STATUS()) {
                return (B1)RedisProtocolReply$.MODULE$.decodeString(A1.tail()).map((Function1 & Serializable)x$5 -> new Status((ByteString)x$5));
            }
            if (A1.head() == RedisProtocolReply$.MODULE$.BULK()) {
                return (B1)RedisProtocolReply$.MODULE$.decodeBulk(A1.tail());
            }
            if (A1.head() == RedisProtocolReply$.MODULE$.MULTIBULK()) {
                return (B1)RedisProtocolReply$.MODULE$.decodeMultiBulk(A1.tail());
            }
            return (B1)function1.apply(x1);
        }

        public final boolean isDefinedAt(ByteString x1) {
            ByteString byteString = x1;
            if (byteString.head() == RedisProtocolReply$.MODULE$.INTEGER()) {
                return true;
            }
            if (byteString.head() == RedisProtocolReply$.MODULE$.STATUS()) {
                return true;
            }
            if (byteString.head() == RedisProtocolReply$.MODULE$.BULK()) {
                return true;
            }
            return byteString.head() == RedisProtocolReply$.MODULE$.MULTIBULK();
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.pekko.util.ByteString )}, serializedLambda);
        }
    };
    private static final PartialFunction<ByteString, DecodeResult<Status>> decodeReplyStatus = new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
            A1 A1 = x2;
            if (A1.head() == RedisProtocolReply$.MODULE$.STATUS()) {
                return (B1)RedisProtocolReply$.MODULE$.decodeString(A1.tail()).map((Function1 & Serializable)x$6 -> new Status((ByteString)x$6));
            }
            return (B1)function1.apply(x2);
        }

        public final boolean isDefinedAt(ByteString x2) {
            ByteString byteString = x2;
            return byteString.head() == RedisProtocolReply$.MODULE$.STATUS();
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.pekko.util.ByteString )}, serializedLambda);
        }
    };
    private static final PartialFunction<ByteString, DecodeResult<Integer>> decodeReplyInteger = new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
            A1 A1 = x3;
            if (A1.head() == RedisProtocolReply$.MODULE$.INTEGER()) {
                return (B1)RedisProtocolReply$.MODULE$.decodeInteger(A1.tail());
            }
            return (B1)function1.apply(x3);
        }

        public final boolean isDefinedAt(ByteString x3) {
            ByteString byteString = x3;
            return byteString.head() == RedisProtocolReply$.MODULE$.INTEGER();
        }
    };
    private static final PartialFunction<ByteString, DecodeResult<Bulk>> decodeReplyBulk = new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
            A1 A1 = x4;
            if (A1.head() == RedisProtocolReply$.MODULE$.BULK()) {
                return (B1)RedisProtocolReply$.MODULE$.decodeBulk(A1.tail());
            }
            return (B1)function1.apply(x4);
        }

        public final boolean isDefinedAt(ByteString x4) {
            ByteString byteString = x4;
            return byteString.head() == RedisProtocolReply$.MODULE$.BULK();
        }
    };
    private static final PartialFunction<ByteString, DecodeResult<MultiBulk>> decodeReplyMultiBulk = new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
            A1 A1 = x5;
            if (A1.head() == RedisProtocolReply$.MODULE$.MULTIBULK()) {
                return (B1)RedisProtocolReply$.MODULE$.decodeMultiBulk(A1.tail());
            }
            return (B1)function1.apply(x5);
        }

        public final boolean isDefinedAt(ByteString x5) {
            ByteString byteString = x5;
            return byteString.head() == RedisProtocolReply$.MODULE$.MULTIBULK();
        }
    };
    private static final PartialFunction<ByteString, DecodeResult<Error>> decodeReplyError = new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
            A1 A1 = x6;
            if (A1.head() == RedisProtocolReply$.MODULE$.ERROR()) {
                return (B1)RedisProtocolReply$.MODULE$.decodeString(A1.tail()).map((Function1 & Serializable)x$7 -> new Error((ByteString)x$7));
            }
            return (B1)function1.apply(x6);
        }

        public final boolean isDefinedAt(ByteString x6) {
            ByteString byteString = x6;
            return byteString.head() == RedisProtocolReply$.MODULE$.ERROR();
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.apache.pekko.util.ByteString )}, serializedLambda);
        }
    };

    public char ERROR() {
        return ERROR;
    }

    public char STATUS() {
        return STATUS;
    }

    public char INTEGER() {
        return INTEGER;
    }

    public char BULK() {
        return BULK;
    }

    public char MULTIBULK() {
        return MULTIBULK;
    }

    public byte[] LS() {
        return LS;
    }

    public DecodeResult<RedisReply> decodeReply(ByteString bs2) {
        if (bs2.isEmpty()) {
            return new PartiallyDecoded<RedisReply>(bs2, (Function1 & Serializable)bs -> MODULE$.decodeReply((ByteString)bs));
        }
        byte by = bs2.head();
        if (this.ERROR() == by) {
            return this.decodeString(bs2.tail()).map((Function1 & Serializable)x$3 -> new Error((ByteString)x$3));
        }
        if (this.INTEGER() == by) {
            return this.decodeInteger(bs2.tail());
        }
        if (this.STATUS() == by) {
            return this.decodeString(bs2.tail()).map((Function1 & Serializable)x$4 -> new Status((ByteString)x$4));
        }
        if (this.BULK() == by) {
            return this.decodeBulk(bs2.tail());
        }
        if (this.MULTIBULK() == by) {
            return this.decodeMultiBulk(bs2.tail());
        }
        throw new Exception(new StringBuilder(51).append("Redis Protocol error: Got ").append(bs2.head()).append(" as initial reply byte >>").append(bs2.tail().utf8String()).toString());
    }

    public PartialFunction<ByteString, DecodeResult<RedisReply>> decodeReplyPF() {
        return decodeReplyPF;
    }

    public PartialFunction<ByteString, DecodeResult<Status>> decodeReplyStatus() {
        return decodeReplyStatus;
    }

    public PartialFunction<ByteString, DecodeResult<Integer>> decodeReplyInteger() {
        return decodeReplyInteger;
    }

    public PartialFunction<ByteString, DecodeResult<Bulk>> decodeReplyBulk() {
        return decodeReplyBulk;
    }

    public PartialFunction<ByteString, DecodeResult<MultiBulk>> decodeReplyMultiBulk() {
        return decodeReplyMultiBulk;
    }

    public PartialFunction<ByteString, DecodeResult<Error>> decodeReplyError() {
        return decodeReplyError;
    }

    public DecodeResult<Integer> decodeInteger(ByteString bs) {
        return this.decodeString(bs).map((Function1 & Serializable)string -> new Integer((ByteString)string));
    }

    public DecodeResult<ByteString> decodeString(ByteString bs2) {
        int index = bs2.indexOf((Object)BoxesRunTime.boxToByte((byte)10));
        if (index >= 0 && bs2.length() >= index + 1) {
            ByteString reply = bs2.take(index + 1 - this.LS().length);
            ByteString tail = bs2.drop(index + 1);
            FullyDecoded<ByteString> r = new FullyDecoded<ByteString>(reply, tail);
            return r;
        }
        return new PartiallyDecoded<ByteString>(bs2, (Function1 & Serializable)bs -> MODULE$.decodeString((ByteString)bs));
    }

    public DecodeResult<Bulk> decodeBulk(ByteString bs) {
        return this.decodeInteger(bs).flatMap((Function2 & Serializable)(integer, bsRest) -> this.decodeBulkBody$1((Integer)integer, (ByteString)bsRest));
    }

    public DecodeResult<MultiBulk> decodeMultiBulk(ByteString bs) {
        return this.decodeInteger(bs).flatMap((Function2 & Serializable)(integer, bsRest) -> {
            int i = integer.toInt();
            if (i < 0) {
                return new FullyDecoded<MultiBulk>(new MultiBulk((Option<Vector<RedisReply>>)None$.MODULE$), (ByteString)bsRest);
            }
            if (i == 0) {
                return new FullyDecoded<MultiBulk>(new MultiBulk((Option<Vector<RedisReply>>)new Some((Object)package$.MODULE$.Vector().empty())), (ByteString)bsRest);
            }
            ReusableBuilder builder = package$.MODULE$.Vector().newBuilder();
            builder.sizeHint(i);
            return MODULE$.bulks(i, (Builder<RedisReply, Vector<RedisReply>>)builder, (ByteString)bsRest);
        });
    }

    public DecodeResult<MultiBulk> bulks(int i2, Builder<RedisReply, Vector<RedisReply>> builder, ByteString byteString) {
        return this.helper$1(i2, byteString, builder).flatMap((Function2 & Serializable)(i, bs) -> RedisProtocolReply$.$anonfun$bulks$2(builder, BoxesRunTime.unboxToInt((Object)i), bs));
    }

    private final DecodeResult decodeBulkBody$1(Integer integer, ByteString bsRest) {
        int i = integer.toInt();
        if (i < 0) {
            return new FullyDecoded<Bulk>(new Bulk((Option<ByteString>)None$.MODULE$), bsRest);
        }
        if (bsRest.length() < i + this.LS().length) {
            return new PartiallyDecoded(bsRest, (Function1 & Serializable)x$8 -> this.decodeBulkBody$1(integer, (ByteString)x$8));
        }
        ByteString data = bsRest.take(i);
        return new FullyDecoded<Bulk>(new Bulk((Option<ByteString>)new Some((Object)data)), bsRest.drop(i).drop(this.LS().length));
    }

    public static final /* synthetic */ int $anonfun$bulks$1(Builder builder$1, int i$1, RedisReply r) {
        builder$1.$plus$eq((Object)r);
        return i$1 - 1;
    }

    private final DecodeResult helper$1(int i, ByteString bs, Builder builder$1) {
        while (i > 0) {
            DecodeResult reply = this.decodeReply(bs).map((Function1 & Serializable)r -> BoxesRunTime.boxToInteger((int)RedisProtocolReply$.$anonfun$bulks$1(builder$1, i, r)));
            if (reply.isFullyDecoded()) {
                bs = reply.rest();
                --i;
                continue;
            }
            return reply;
        }
        return new FullyDecoded<java.lang.Integer>(BoxesRunTime.boxToInteger((int)0), bs);
    }

    public static final /* synthetic */ DecodeResult $anonfun$bulks$2(Builder builder$1, int i, ByteString bs) {
        if (i > 0) {
            return MODULE$.bulks(i, (Builder<RedisReply, Vector<RedisReply>>)builder$1, bs);
        }
        return new FullyDecoded<MultiBulk>(new MultiBulk((Option<Vector<RedisReply>>)new Some(builder$1.result())), bs);
    }

    private RedisProtocolReply$() {
    }
}

