/*
 * Decompiled with CFR 0.152.
 */
package io.github.pandalxb.jpowershell;

import io.github.pandalxb.jpowershell.PowerShell;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

class PowerShellCommandProcessor
implements Callable<String> {
    private final BufferedReader reader;
    private boolean closed = false;
    private final int waitPause;

    public PowerShellCommandProcessor(String name, InputStream inputStream, int waitPause) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        this.waitPause = waitPause;
    }

    @Override
    public String call() throws InterruptedException {
        StringBuilder powerShellOutput = new StringBuilder();
        try {
            if (this.startReading()) {
                this.readData(powerShellOutput);
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error reading PowerShell output", ioe);
            return ioe.getMessage();
        }
        return powerShellOutput.toString();
    }

    private void readData(StringBuilder powerShellOutput) throws IOException {
        String line;
        boolean isReadyFinishing = false;
        int lineIndex = 0;
        while (null != (line = this.reader.readLine())) {
            if (line.equals("--END-JPOWERSHELL-COMMAND--")) {
                isReadyFinishing = true;
            } else {
                if (lineIndex > 0) {
                    powerShellOutput.append(System.lineSeparator());
                }
                if (line.contains("; if ($?) { Write-Output \"--END-JPOWERSHELL-COMMAND--\" }")) {
                    isReadyFinishing = true;
                    line = line.replace("; if ($?) { Write-Output \"--END-JPOWERSHELL-COMMAND--\" }", "");
                }
                powerShellOutput.append(line);
                ++lineIndex;
            }
            try {
                if (!this.closed && (!isReadyFinishing || this.canContinueReading())) continue;
                break;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PowerShellCommandProcessor.class.getName()).log(Level.SEVERE, "Error executing command and reading result", ex);
            }
        }
    }

    private boolean startReading() throws IOException, InterruptedException {
        while (!this.reader.ready()) {
            Thread.sleep(this.waitPause);
            if (!this.closed) continue;
            return false;
        }
        return true;
    }

    private boolean canContinueReading() throws IOException, InterruptedException {
        if (!this.reader.ready()) {
            Thread.sleep(this.waitPause);
        }
        if (!this.reader.ready()) {
            Thread.sleep(this.waitPause);
        }
        return this.reader.ready();
    }

    public void close() {
        this.closed = true;
    }
}

