/*
 * Decompiled with CFR 0.152.
 */
package io.github.pandalxb.jlibrehardwaremonitor.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensorsUtils.class);

    private SensorsUtils() {
    }

    public static String generateLibPath(String path, String libName) {
        File libFile;
        block29: {
            String libsPath = System.getProperty("user.dir") + File.separator + "lib" + File.separator;
            libFile = new File(libsPath + libName);
            try {
                boolean isSuccess = true;
                if (libFile.exists()) break block29;
                File libsDir = new File(libsPath);
                if (!libsDir.exists()) {
                    isSuccess = libsDir.mkdirs();
                }
                if (!isSuccess) break block29;
                try (InputStream input = SensorsUtils.class.getResourceAsStream(path + libName);
                     FileOutputStream output = new FileOutputStream(libFile);){
                    int bytesRead;
                    if (input == null) {
                        throw new RuntimeException("resources/" + path + "/" + libName + " not found");
                    }
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = input.read(buffer)) != -1) {
                        output.write(buffer, 0, bytesRead);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot generate lib file", (Throwable)e);
                return "";
            }
        }
        return libFile.getAbsolutePath();
    }
}

