/*
 * Decompiled with CFR 0.152.
 */
package io.github.pandalxb.jlibrehardwaremonitor.util;

import io.github.pandalxb.jlibrehardwaremonitor.model.Computer;
import io.github.pandalxb.jlibrehardwaremonitor.model.Hardware;
import io.github.pandalxb.jlibrehardwaremonitor.model.Sensor;
import java.util.ArrayList;
import java.util.List;

public class JsonParser {
    public static Computer parseJson(String jsonString) {
        if (!(jsonString = jsonString.trim()).startsWith("{") || !jsonString.endsWith("}")) {
            throw new IllegalArgumentException("Invalid JSON format");
        }
        jsonString = jsonString.substring(1, jsonString.length() - 1);
        Computer computer = new Computer();
        while (!jsonString.isEmpty()) {
            int endIndex;
            int colonIndex = jsonString.indexOf(":");
            String key = jsonString.substring(0, colonIndex).trim().replaceAll("\"", "");
            if ((jsonString = jsonString.substring(colonIndex + 1).trim()).startsWith("[")) {
                endIndex = JsonParser.findMatchingBracket(jsonString, '[', ']');
                String jsonArrayStr = jsonString.substring(0, endIndex + 1);
                if ("hardware".equals(key)) {
                    List<Hardware> hardwareList = JsonParser.parseHardwareArray(jsonArrayStr);
                    computer.setHardware(hardwareList);
                }
                jsonString = jsonString.substring(endIndex + 1).trim();
            } else if (jsonString.startsWith("{")) {
                endIndex = JsonParser.findMatchingBracket(jsonString, '{', '}');
                jsonString = jsonString.substring(endIndex + 1).trim();
            } else {
                String string = jsonString = jsonString.contains(",") ? jsonString.substring(jsonString.indexOf(",") + 1) : "";
            }
            if (!jsonString.startsWith(",")) continue;
            jsonString = jsonString.substring(1).trim();
        }
        return computer;
    }

    private static int findMatchingBracket(String str, char openBracket, char closeBracket) {
        int depth = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == openBracket) {
                ++depth;
            } else if (c == closeBracket) {
                --depth;
            }
            if (depth != 0) continue;
            return i;
        }
        return -1;
    }

    private static List<Hardware> parseHardwareArray(String jsonArrayStr) {
        ArrayList<Hardware> hardwareList = new ArrayList<Hardware>();
        jsonArrayStr = jsonArrayStr.trim().replaceAll("^\\[|]$", "");
        while (!jsonArrayStr.isEmpty()) {
            int bracketIndex = JsonParser.findMatchingBracket(jsonArrayStr, '{', '}');
            String objectStr = jsonArrayStr.substring(0, bracketIndex + 1);
            Hardware hardware = JsonParser.parseHardwareObject(objectStr);
            hardwareList.add(hardware);
            if (!(jsonArrayStr = jsonArrayStr.substring(bracketIndex + 1).trim()).startsWith(",")) continue;
            jsonArrayStr = jsonArrayStr.substring(1).trim();
        }
        return hardwareList;
    }

    private static Hardware parseHardwareObject(String objectStr) {
        Hardware hardware = new Hardware();
        objectStr = objectStr.trim().replaceAll("^\\{|}$", "");
        while (!objectStr.isEmpty()) {
            int colonIndex = objectStr.indexOf(":");
            String key = objectStr.substring(0, colonIndex).trim().replaceAll("\"", "");
            if ((objectStr = objectStr.substring(colonIndex + 1).trim()).startsWith("\"")) {
                int quoteEndIndex = objectStr.indexOf("\"", 1);
                String value = objectStr.substring(1, quoteEndIndex);
                switch (key) {
                    case "hardwareType": {
                        hardware.setHardwareType(value);
                        break;
                    }
                    case "name": {
                        hardware.setName(value);
                    }
                }
                objectStr = objectStr.substring(quoteEndIndex + 1).trim();
            } else if (objectStr.startsWith("[")) {
                int endIndex = JsonParser.findMatchingBracket(objectStr, '[', ']');
                String jsonArrayStr = objectStr.substring(0, endIndex + 1);
                if ("subHardware".equals(key)) {
                    List<Hardware> subHardware = JsonParser.parseHardwareArray(jsonArrayStr);
                    hardware.setSubHardware(subHardware);
                } else if ("sensors".equals(key)) {
                    List<Sensor> sensors = JsonParser.parseSensorArray(jsonArrayStr);
                    hardware.setSensors(sensors);
                }
                objectStr = objectStr.substring(endIndex + 1).trim();
            }
            if (!objectStr.startsWith(",")) continue;
            objectStr = objectStr.substring(1).trim();
        }
        return hardware;
    }

    private static List<Sensor> parseSensorArray(String jsonArrayStr) {
        ArrayList<Sensor> sensorList = new ArrayList<Sensor>();
        jsonArrayStr = jsonArrayStr.trim().replaceAll("^\\[|]$", "");
        while (!jsonArrayStr.isEmpty()) {
            int bracketIndex = JsonParser.findMatchingBracket(jsonArrayStr, '{', '}');
            String objectStr = jsonArrayStr.substring(0, bracketIndex + 1);
            Sensor sensor = JsonParser.parseSensorObject(objectStr);
            sensorList.add(sensor);
            if (!(jsonArrayStr = jsonArrayStr.substring(bracketIndex + 1).trim()).startsWith(",")) continue;
            jsonArrayStr = jsonArrayStr.substring(1).trim();
        }
        return sensorList;
    }

    private static Sensor parseSensorObject(String objectStr) {
        Sensor sensor = new Sensor();
        objectStr = objectStr.trim().replaceAll("^\\{|}$", "");
        while (!objectStr.isEmpty()) {
            int colonIndex = objectStr.indexOf(":");
            String key = objectStr.substring(0, colonIndex).trim().replaceAll("\"", "");
            if ((objectStr = objectStr.substring(colonIndex + 1).trim()).startsWith("\"")) {
                int quoteEndIndex = objectStr.indexOf("\"", 1);
                String value = objectStr.substring(1, quoteEndIndex);
                switch (key) {
                    case "sensorType": {
                        sensor.setSensorType(value);
                        break;
                    }
                    case "name": {
                        sensor.setName(value);
                    }
                }
                objectStr = objectStr.substring(quoteEndIndex + 1).trim();
            } else if (objectStr.startsWith("[")) {
                objectStr = objectStr.substring(JsonParser.findMatchingBracket(objectStr, '[', ']') + 1).trim();
            } else {
                double value = Double.parseDouble(objectStr.split(",")[0].trim());
                sensor.setValue(value);
                String string = objectStr = objectStr.contains(",") ? objectStr.substring(objectStr.indexOf(",") + 1) : "";
            }
            if (!objectStr.startsWith(",")) continue;
            objectStr = objectStr.substring(1).trim();
        }
        return sensor;
    }
}

