/*
 * Decompiled with CFR 0.152.
 */
package io.github.pandalxb.jlibrehardwaremonitor.standalone;

import io.github.pandalxb.jlibrehardwaremonitor.config.ComputerConfig;
import io.github.pandalxb.jlibrehardwaremonitor.manager.LibreHardwareManager;
import io.github.pandalxb.jlibrehardwaremonitor.manager.powershell.PowerShellOperations;
import io.github.pandalxb.jlibrehardwaremonitor.model.Computer;
import io.github.pandalxb.jlibrehardwaremonitor.model.Hardware;
import io.github.pandalxb.jlibrehardwaremonitor.model.Sensor;
import io.github.pandalxb.jlibrehardwaremonitor.util.OSDetector;
import java.awt.EventQueue;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;

public class GuiOutput {
    public static void showOutput(Map<String, String> config) {
        EventQueue.invokeLater(() -> {
            GuiOutput guiOutput = new GuiOutput();
            guiOutput.getClass();
            JLibreHardwareMonitorGUI gui = guiOutput.new JLibreHardwareMonitorGUI(config);
            gui.setVisible(true);
        });
    }

    class JLibreHardwareMonitorGUI
    extends JFrame {
        private Map<String, String> config;
        private JTable table = new JTable();

        public JLibreHardwareMonitorGUI(Map<String, String> config) {
            this.config = config;
            this.initUI();
        }

        private void initUI() {
            this.setTitle("JLibreHardwareMonitor");
            this.setSize(600, 800);
            this.setLocationRelativeTo(null);
            this.setDefaultCloseOperation(3);
            if (OSDetector.isWindows() && !PowerShellOperations.isAdministrator()) {
                JOptionPane.showMessageDialog(this, "You have not executed JLibreHardwareMonitor in Administrator mode, so CPU temperature sensors will not be detected.");
            }
            new GuiUpdater(this).execute();
        }

        private DefaultTableModel initModel() {
            return new DefaultTableModel(new Object[]{"Hardware/Sensor", "Value"}, 0);
        }

        private DefaultTableModel calculateModel() {
            DefaultTableModel model = this.initModel();
            Computer computer = LibreHardwareManager.createInstance(ComputerConfig.getInstance().enableAll()).getComputer();
            for (Hardware hardware : computer.getHardware()) {
                model.addRow(new String[]{String.format("%s:%s", hardware.getHardwareType(), hardware.getName()), ""});
                for (Hardware subHardware : hardware.getSubHardware()) {
                    model.addRow(new String[]{String.format("<html><div style='padding-left: 20px;'>%s:%s</div></html>", subHardware.getHardwareType(), subHardware.getName()), ""});
                    for (Sensor sensor : subHardware.getSensors()) {
                        model.addRow(new String[]{String.format("<html><div style='padding-left: 40px;'>%s:%s</div></html>", sensor.getSensorType(), sensor.getName()), String.valueOf(sensor.getValue())});
                    }
                }
                for (Sensor sensor : hardware.getSensors()) {
                    model.addRow(new String[]{String.format("<html><div style='padding-left: 20px;'>%s:%s</div></html>", sensor.getSensorType(), sensor.getName()), String.valueOf(sensor.getValue())});
                }
            }
            return model;
        }

        private class GuiUpdater
        extends SwingWorker<Void, Void> {
            public GuiUpdater(JLibreHardwareMonitorGUI jLibreHardwareMonitorGUI2) {
                JScrollPane scrollPane = new JScrollPane(JLibreHardwareMonitorGUI.this.table);
                JLibreHardwareMonitorGUI.this.table.setFillsViewportHeight(true);
                jLibreHardwareMonitorGUI2.add(scrollPane);
            }

            @Override
            protected Void doInBackground() {
                while (true) {
                    JLibreHardwareMonitorGUI.this.table.setModel(JLibreHardwareMonitorGUI.this.calculateModel());
                    JLibreHardwareMonitorGUI.this.table.getColumnModel().getColumn(0).setPreferredWidth(400);
                    JLibreHardwareMonitorGUI.this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
                }
            }
        }
    }
}

