/*
 * Decompiled with CFR 0.152.
 */
package io.github.pandalxb.jlibrehardwaremonitor.standalone;

import io.github.pandalxb.jlibrehardwaremonitor.config.ComputerConfig;
import io.github.pandalxb.jlibrehardwaremonitor.manager.LibreHardwareManager;
import io.github.pandalxb.jlibrehardwaremonitor.model.Computer;
import io.github.pandalxb.jlibrehardwaremonitor.model.Hardware;
import io.github.pandalxb.jlibrehardwaremonitor.model.Sensor;
import java.util.Map;

public class ConsoleOutput {
    public static void showOutput(Map<String, String> config) {
        System.out.println("Scanning sensors data...");
        Computer computer = LibreHardwareManager.createInstance(ComputerConfig.getInstance().enableAll()).getComputer();
        for (Hardware hardware : computer.getHardware()) {
            System.out.println(String.format("HardwareType:%s, Name:%s", hardware.getHardwareType(), hardware.getName()));
            for (Hardware subHardware : hardware.getSubHardware()) {
                System.out.println(String.format("\tSubHardwareType:%s, Name:%s", subHardware.getHardwareType(), subHardware.getName()));
                for (Sensor sensor : subHardware.getSensors()) {
                    System.out.println(String.format("\t\tSensorType:%s, Name:%s, value:%s", sensor.getSensorType(), sensor.getName(), sensor.getValue()));
                }
            }
            for (Sensor sensor : hardware.getSensors()) {
                System.out.println(String.format("\tSensorType:%s, Name:%s, value:%s", sensor.getSensorType(), sensor.getName(), sensor.getValue()));
            }
        }
    }
}

