/*
 * Decompiled with CFR 0.152.
 */
package io.github.pandalxb.jlibrehardwaremonitor.manager.powershell;

import io.github.pandalxb.jlibrehardwaremonitor.config.ComputerConfig;
import io.github.pandalxb.jlibrehardwaremonitor.manager.powershell.PowerShellScriptHelper;
import io.github.pandalxb.jpowershell.PowerShell;

public enum PowerShellOperations {
    GET;

    private static final PowerShell powerShell;

    public static boolean isAdministrator() {
        String command = "([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole] \"Administrator\")";
        return "true".equalsIgnoreCase(powerShell.executeCommand(command).getCommandOutput());
    }

    public String getComputerJsonData(ComputerConfig config) {
        return powerShell.executeCommand(PowerShellScriptHelper.getPowerShellScriptForSingleLine(config)).getCommandOutput();
    }

    public String getEnvironmentVersion() {
        return powerShell.executeCommand("[Environment]::Version.ToString()").getCommandOutput();
    }

    static {
        powerShell = PowerShell.openSession();
    }
}

