/*
 * Decompiled with CFR 0.152.
 */
package io.github.pandalxb.jlibrehardwaremonitor.manager;

import io.github.pandalxb.jlibrehardwaremonitor.config.ComputerConfig;
import io.github.pandalxb.jlibrehardwaremonitor.manager.powershell.PowerShellOperations;
import io.github.pandalxb.jlibrehardwaremonitor.model.Computer;
import io.github.pandalxb.jlibrehardwaremonitor.model.Hardware;
import io.github.pandalxb.jlibrehardwaremonitor.model.Sensor;
import io.github.pandalxb.jlibrehardwaremonitor.util.CollectionUtils;
import io.github.pandalxb.jlibrehardwaremonitor.util.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibreHardwareManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibreHardwareManager.class);
    private static final Map<String, String> hardwareTypeAliasMap = new HashMap<String, String>();
    private static final long BUFFER_SECONDS = 1L;
    private static LibreHardwareManager instance;
    private ComputerConfig config;
    private Computer computer;
    private long lastUpdateTime = -1L;

    private LibreHardwareManager() {
        new LibreHardwareManager(null);
    }

    private LibreHardwareManager(ComputerConfig config) {
        if (config == null) {
            config = ComputerConfig.getInstance().setCpuEnabled(true);
        }
        this.setConfig(config);
    }

    public static LibreHardwareManager getInstance(ComputerConfig config) {
        if (instance == null) {
            instance = LibreHardwareManager.createInstance(config);
        } else {
            instance.setConfig(config);
        }
        return instance;
    }

    public static LibreHardwareManager createInstance() {
        return LibreHardwareManager.createInstance(null);
    }

    public static LibreHardwareManager createInstance(ComputerConfig config) {
        return new LibreHardwareManager(config);
    }

    private void setConfig(ComputerConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Computer getComputer() {
        String jsonData = PowerShellOperations.GET.getComputerJsonData(this.config);
        Computer computer = null;
        try {
            computer = JsonParser.parseJson(jsonData);
        }
        catch (Exception e) {
            LOGGER.error("JsonParser.parseJson error:{}, jsonData:{}", (Object)e, (Object)jsonData);
        }
        finally {
            if (computer == null) {
                computer = new Computer();
            }
        }
        return computer;
    }

    public List<Sensor> querySensors(String hardwareType, String sensorType) {
        if (this.lastUpdateTime < 0L || System.currentTimeMillis() - this.lastUpdateTime > 1000L) {
            this.computer = this.getComputer();
            this.lastUpdateTime = System.currentTimeMillis();
        }
        ArrayList<Sensor> list = new ArrayList<Sensor>();
        if (this.computer == null) {
            return list;
        }
        if (CollectionUtils.isNotEmpty(this.computer.getHardware())) {
            for (Hardware hardware : this.computer.getHardware()) {
                if (this.isHardwareTypeMatch(hardware.getHardwareType(), hardwareType) && CollectionUtils.isNotEmpty(hardware.getSensors())) {
                    for (Sensor sensor : hardware.getSensors()) {
                        if (!sensor.getSensorType().equalsIgnoreCase(sensorType)) continue;
                        list.add(sensor);
                    }
                }
                if (!CollectionUtils.isNotEmpty(hardware.getSubHardware())) continue;
                for (Hardware subHardware : hardware.getSubHardware()) {
                    if (!this.isHardwareTypeMatch(subHardware.getHardwareType(), hardwareType) || !CollectionUtils.isNotEmpty(subHardware.getSensors())) continue;
                    for (Sensor sensor : subHardware.getSensors()) {
                        if (!sensor.getSensorType().equalsIgnoreCase(sensorType)) continue;
                        list.add(sensor);
                    }
                }
            }
        }
        return list;
    }

    private boolean isHardwareTypeMatch(String hardwareType, String queryHardwareType) {
        return hardwareType.equalsIgnoreCase(queryHardwareType) || hardwareTypeAliasMap.containsKey(queryHardwareType) && hardwareType.equalsIgnoreCase(hardwareTypeAliasMap.get(queryHardwareType)) || queryHardwareType.equalsIgnoreCase("gpu") && hardwareType.toLowerCase().startsWith("gpu");
    }

    static {
        hardwareTypeAliasMap.put("Memory", "RAM");
        hardwareTypeAliasMap.put("Motherboard", "Mainboard");
        hardwareTypeAliasMap.put("Storage", "HDD");
    }
}

