/*
 * Decompiled with CFR 0.152.
 */
package io.github.pandalxb.jlibrehardwaremonitor;

import io.github.pandalxb.jlibrehardwaremonitor.manager.powershell.PowerShellOperations;
import io.github.pandalxb.jlibrehardwaremonitor.standalone.ConsoleOutput;
import io.github.pandalxb.jlibrehardwaremonitor.standalone.GuiOutput;
import io.github.pandalxb.jlibrehardwaremonitor.util.OSDetector;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JLibreHardwareMonitor {
    get;

    private static final Logger LOGGER;

    private static void checkRights() {
        if (OSDetector.isWindows() && !PowerShellOperations.isAdministrator()) {
            LOGGER.warn("You have not executed jLibreHardwareMonitor in Administrator mode, so CPU temperature sensors will not be detected.");
        }
    }

    public static void main(String[] args) {
        boolean guiMode = false;
        HashMap<String, String> overriddenConfig = new HashMap<String, String>();
        for (String arg : args) {
            if ("--debug".equals(arg)) {
                overriddenConfig.put("debugMode", "true");
            }
            if (!"--gui".equals(arg)) continue;
            guiMode = true;
        }
        if (guiMode) {
            GuiOutput.showOutput(overriddenConfig);
        } else {
            ConsoleOutput.showOutput(overriddenConfig);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(JLibreHardwareMonitor.class);
        JLibreHardwareMonitor.checkRights();
    }
}

