/*
 * Decompiled with CFR 0.152.
 */
package feign.opentracing;

import feign.Request;
import feign.Response;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;

public interface FeignSpanDecorator {
    public void onRequest(Request var1, Request.Options var2, Span var3);

    public void onResponse(Response var1, Request.Options var2, Span var3);

    public void onError(Exception var1, Request var2, Span var3);

    public static class StandardTags
    implements FeignSpanDecorator {
        @Override
        public void onRequest(Request request, Request.Options options, Span span) {
            Tags.COMPONENT.set(span, "feign");
            Tags.HTTP_URL.set(span, request.url());
            Tags.HTTP_METHOD.set(span, request.method());
        }

        @Override
        public void onResponse(Response response, Request.Options options, Span span) {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(response.status()));
        }

        @Override
        public void onError(Exception exception, Request request, Span span) {
            Tags.ERROR.set(span, Boolean.TRUE);
            span.log(StandardTags.errorLogs(exception));
        }

        public static Map<String, Object> errorLogs(Exception ex) {
            HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
            errorLogs.put("event", Tags.ERROR.getKey());
            errorLogs.put("error.object", ex);
            return errorLogs;
        }
    }
}

