/*
 * Decompiled with CFR 0.152.
 */
package io.github.mweirauch.micrometer.jvm.extras.procfs;

import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsEntry;
import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsReader;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcfsStatus
extends ProcfsEntry {
    private static final Pattern VAL_LINE_PATTERN = Pattern.compile("^\\w+:\\s+(\\d+)$");
    private static final Pattern KB_LINE_PATTERN = Pattern.compile("^\\w+:\\s+(\\d+)\\skB$");
    private static final int KILOBYTE = 1024;

    ProcfsStatus() {
        super(ProcfsReader.getInstance("status"));
    }

    ProcfsStatus(ProcfsReader reader) {
        super(reader);
    }

    @Override
    protected void handle(Map<ProcfsEntry.ValueKey, Double> values, String line) {
        Objects.requireNonNull(values);
        Objects.requireNonNull(line);
        if (line.startsWith("Threads:")) {
            values.put(KEY.THREADS, ProcfsStatus.parseValue(line));
        } else if (line.startsWith("VmSize:")) {
            values.put(KEY.VSS, ProcfsStatus.parseKiloBytes(line) * 1024.0);
        } else if (line.startsWith("VmRSS:")) {
            values.put(KEY.RSS, ProcfsStatus.parseKiloBytes(line) * 1024.0);
        } else if (line.startsWith("VmSwap:")) {
            values.put(KEY.SWAP, ProcfsStatus.parseKiloBytes(line) * 1024.0);
        }
    }

    private static Double parseValue(String line) {
        Objects.requireNonNull(line);
        Matcher matcher = VAL_LINE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return Double.NaN;
        }
        return Double.parseDouble(matcher.group(1));
    }

    private static Double parseKiloBytes(String line) {
        Objects.requireNonNull(line);
        Matcher matcher = KB_LINE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return Double.NaN;
        }
        return Double.parseDouble(matcher.group(1));
    }

    public static ProcfsStatus getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        static final ProcfsStatus INSTANCE = new ProcfsStatus();

        private InstanceHolder() {
        }
    }

    public static enum KEY implements ProcfsEntry.ValueKey
    {
        THREADS,
        VSS,
        RSS,
        SWAP;

    }
}

