/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import graphql.analysis.QueryTraverser;
import graphql.analysis.QueryVisitor;
import graphql.language.Document;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.github.microcks.util.JsonSchemaValidator;
import io.github.microcks.util.graphql.JsonSchemaBuilderQueryVisitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLSchemaValidator {
    private static Logger log = LoggerFactory.getLogger(GraphQLSchemaValidator.class);
    public static final String GRAPHQL_RESPONSE_DATA = "data";
    private static final ObjectMapper mapper = new ObjectMapper();

    public static JsonNode buildResponseJsonSchema(String schemaText, String query) throws IOException {
        TypeDefinitionRegistry registry = new SchemaParser().parse(schemaText);
        GraphQLSchema schema = new SchemaGenerator().makeExecutableSchema(registry, RuntimeWiring.MOCKED_WIRING);
        Document graphqlRequest = new Parser().parseDocument(query);
        QueryTraverser queryTraversal = QueryTraverser.newQueryTraverser().schema(schema).document(graphqlRequest).variables(new HashMap()).build();
        ObjectNode jsonSchema = GraphQLSchemaValidator.initResponseJsonSchema();
        JsonSchemaBuilderQueryVisitor visitor = new JsonSchemaBuilderQueryVisitor((ObjectNode)jsonSchema.get("properties").get(GRAPHQL_RESPONSE_DATA));
        queryTraversal.visitPreOrder((QueryVisitor)visitor);
        return jsonSchema;
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode) {
        return JsonSchemaValidator.validateJson(schemaNode, jsonNode);
    }

    private static ObjectNode initResponseJsonSchema() {
        ObjectNode jsonSchema = mapper.createObjectNode();
        jsonSchema.put("$schema", "http://json-schema.org/draft/2020-12/schema#");
        jsonSchema.put("type", "object");
        jsonSchema.put("additionalProperties", false);
        jsonSchema.putArray("required").add(GRAPHQL_RESPONSE_DATA);
        ObjectNode properties = jsonSchema.putObject("properties");
        ObjectNode data = properties.putObject(GRAPHQL_RESPONSE_DATA);
        data.put("type", "object");
        data.putObject("properties");
        return jsonSchema;
    }
}

