/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.io.File;
import java.util.List;

public class WebsphereLibertyClassLoaderHandler
implements ClassLoaderHandler {
    private static final String PKG_PREFIX = "com.ibm.ws.classloading.internal.";
    private static final String IBM_APP_CLASS_LOADER = "com.ibm.ws.classloading.internal.AppClassLoader";
    private static final String IBM_THREAD_CONTEXT_CLASS_LOADER = "com.ibm.ws.classloading.internal.ThreadContextClassLoader";
    public static final String[] HANDLED_CLASSLOADERS = new String[]{"com.ibm.ws.classloading.internal.AppClassLoader", "com.ibm.ws.classloading.internal.ThreadContextClassLoader"};

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ClassLoader classLoader, ClasspathFinder classpathFinder, ScanSpec scanSpec, LogNode log) throws Exception {
        List classPathElements;
        Object smartClassPath = null;
        Object appLoader = ReflectionUtils.getFieldVal(classLoader, "appLoader");
        smartClassPath = appLoader != null ? ReflectionUtils.getFieldVal(appLoader, "smartClassPath") : ReflectionUtils.getFieldVal(classLoader, "smartClassPath");
        if (smartClassPath != null && (classPathElements = (List)ReflectionUtils.getFieldVal(smartClassPath, "classPath")) != null) {
            for (Object classpath : classPathElements) {
                String path = this.getPath(classpath);
                if (path == null || path.length() <= 0) continue;
                classpathFinder.addClasspathElement(path, classLoader, log);
            }
        }
    }

    private String getPath(Object classpath) throws Exception {
        Object container = ReflectionUtils.getFieldVal(classpath, "container");
        if (container == null) {
            return "";
        }
        Object delegate = ReflectionUtils.getFieldVal(container, "delegate");
        if (delegate == null) {
            return "";
        }
        String path = (String)ReflectionUtils.getFieldVal(delegate, "path");
        if (path != null && path.length() > 0) {
            return path;
        }
        Object base = ReflectionUtils.getFieldVal(delegate, "base");
        if (base == null) {
            return "";
        }
        Object archiveFile = ReflectionUtils.getFieldVal(base, "archiveFile");
        if (archiveFile != null) {
            File file = (File)archiveFile;
            return file.getAbsolutePath();
        }
        return "";
    }
}

