/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static Object getFieldVal(Object obj, String fieldName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Field field = classOrSuperclass.getDeclaredField(fieldName);
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    return field.get(obj);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Method method = classOrSuperclass.getDeclaredMethod(methodName, new Class[0]);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?> argType, Object arg) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Method method = classOrSuperclass.getDeclaredMethod(methodName, argType);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method.invoke(obj, arg);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (cls != null) {
            try {
                Method method = cls.getDeclaredMethod(methodName, new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Class<?> argType, Object arg) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (cls != null) {
            try {
                Method method = cls.getDeclaredMethod(methodName, argType);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method.invoke(null, arg);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }
}

