/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ImplementingClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;

public class ScanSpec {
    private final ArrayList<String> whitelistedPathPrefixes = new ArrayList();
    private final ArrayList<String> blacklistedPathPrefixes = new ArrayList();
    private final ArrayList<String> blacklistedPackagePrefixes = new ArrayList();
    private final HashSet<String> specificallyWhitelistedClassRelativePaths = new HashSet();
    private final HashSet<String> specificallyWhitelistedClassParentRelativePaths = new HashSet();
    private final HashSet<String> specificallyBlacklistedClassRelativePaths = new HashSet();
    private final HashSet<String> specificallyBlacklistedClassNames = new HashSet();
    private final HashSet<String> whitelistedJars = new HashSet();
    private final HashSet<String> blacklistedJars = new HashSet();
    private final ArrayList<Pattern> whitelistedJarPatterns = new ArrayList();
    private final ArrayList<Pattern> blacklistedJarPatterns = new ArrayList();
    final boolean scanJars;
    boolean scanDirs;
    public boolean enableFieldTypeIndexing;
    public String overrideClasspath;
    public boolean strictWhitelist;
    public final ArrayList<Class<? extends ClassLoaderHandler>> extraClassLoaderHandlers = new ArrayList();
    private MultiMapKeyToList<String, StaticFinalFieldMatchProcessor> fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors;
    private MultiMapKeyToSet<String, String> classNameToStaticFinalFieldsToMatch;
    private ArrayList<ClassMatcher> classMatchers;
    private final List<FilePathTesterAndMatchProcessorWrapper> filePathTestersAndMatchProcessorWrappers = new ArrayList<FilePathTesterAndMatchProcessorWrapper>();
    private boolean blacklistSystemJars = true;
    private boolean blacklistSystemPackages = true;
    public boolean ignoreFieldVisibility = false;
    final List<ClassLoader> classLoaders;
    private static CallerResolver CALLER_RESOLVER;

    public MultiMapKeyToSet<String, String> getClassNameToStaticFinalFieldsToMatch() {
        return this.classNameToStaticFinalFieldsToMatch;
    }

    public ScanSpec(String[] scanSpec, LogNode log) {
        HashSet<String> uniqueWhitelistedPathPrefixes = new HashSet<String>();
        HashSet<String> uniqueBlacklistedPathPrefixes = new HashSet<String>();
        boolean scanJars = true;
        boolean scanNonJars = true;
        String[] stringArray = scanSpec;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String scanSpecEntry;
            String spec = scanSpecEntry = stringArray[i];
            if ("!".equals(scanSpecEntry)) {
                this.blacklistSystemPackages = false;
                continue;
            }
            if ("!!".equals(scanSpecEntry)) {
                this.blacklistSystemJars = false;
                this.blacklistSystemPackages = false;
                continue;
            }
            boolean blacklisted = spec.startsWith("-");
            if (blacklisted) {
                spec = spec.substring(1);
            }
            if (spec.startsWith("jar:")) {
                if ((spec = spec.substring(4)).indexOf(47) >= 0) {
                    if (log == null) continue;
                    log.log("Only a leaf filename may be used with a \"jar:\" entry in the scan spec, got \"" + spec + "\" -- ignoring");
                    continue;
                }
                if (spec.isEmpty()) {
                    if (blacklisted) {
                        scanJars = false;
                        continue;
                    }
                    scanNonJars = false;
                    continue;
                }
                if (blacklisted) {
                    if (spec.contains("*")) {
                        this.blacklistedJarPatterns.add(ScanSpec.specToPattern(spec));
                        continue;
                    }
                    this.blacklistedJars.add(spec);
                    continue;
                }
                if (spec.contains("*")) {
                    this.whitelistedJarPatterns.add(ScanSpec.specToPattern(spec));
                    continue;
                }
                this.whitelistedJars.add(spec);
                continue;
            }
            String specPath = spec.replace('.', '/');
            boolean isClassName = false;
            int lastSlashIdx = specPath.lastIndexOf(47);
            if (lastSlashIdx < specPath.length() - 1) {
                isClassName = Character.isUpperCase(specPath.charAt(lastSlashIdx + 1));
            }
            if (isClassName) {
                if (blacklisted) {
                    this.specificallyBlacklistedClassNames.add(spec);
                    this.specificallyBlacklistedClassRelativePaths.add(specPath + ".class");
                    continue;
                }
                this.specificallyWhitelistedClassRelativePaths.add(specPath + ".class");
                continue;
            }
            if (blacklisted) {
                uniqueBlacklistedPathPrefixes.add(specPath + "/");
                continue;
            }
            uniqueWhitelistedPathPrefixes.add(specPath + "/");
        }
        if (uniqueBlacklistedPathPrefixes.contains("/")) {
            if (log != null) {
                log.log("Ignoring blacklist of root package, it would prevent all scanning");
            }
            uniqueBlacklistedPathPrefixes.remove("/");
        }
        uniqueWhitelistedPathPrefixes.removeAll(uniqueBlacklistedPathPrefixes);
        this.whitelistedJars.removeAll(this.blacklistedJars);
        if (!this.whitelistedJars.isEmpty() || !this.whitelistedJarPatterns.isEmpty()) {
            scanNonJars = false;
        }
        if (!scanJars && !scanNonJars) {
            if (log != null) {
                log.log("Scanning of jars and non-jars are both disabled -- re-enabling scanning of non-jars");
            }
            scanNonJars = true;
        }
        if (uniqueWhitelistedPathPrefixes.isEmpty() || uniqueWhitelistedPathPrefixes.contains("/")) {
            this.whitelistedPathPrefixes.add("");
        } else {
            this.whitelistedPathPrefixes.addAll(uniqueWhitelistedPathPrefixes);
        }
        if (this.blacklistSystemPackages) {
            uniqueBlacklistedPathPrefixes.add("java/");
            uniqueBlacklistedPathPrefixes.add("javax/");
            uniqueBlacklistedPathPrefixes.add("sun/");
        }
        this.blacklistedPathPrefixes.addAll(uniqueBlacklistedPathPrefixes);
        for (String prefix : this.blacklistedPathPrefixes) {
            this.blacklistedPackagePrefixes.add(prefix.replace('/', '.'));
        }
        this.specificallyWhitelistedClassRelativePaths.removeAll(this.specificallyBlacklistedClassRelativePaths);
        for (String whitelistedClass : this.specificallyWhitelistedClassRelativePaths) {
            int lastSlashIdx = whitelistedClass.lastIndexOf(47);
            this.specificallyWhitelistedClassParentRelativePaths.add(whitelistedClass.substring(0, lastSlashIdx + 1));
        }
        this.scanJars = scanJars;
        this.scanDirs = scanNonJars;
        if (log != null) {
            log.log("Whitelisted relative path prefixes:  " + this.whitelistedPathPrefixes);
            if (!this.blacklistedPathPrefixes.isEmpty()) {
                log.log("Blacklisted relative path prefixes:  " + this.blacklistedPathPrefixes);
            }
            if (!this.whitelistedJars.isEmpty()) {
                log.log("Whitelisted jars:  " + this.whitelistedJars);
            }
            if (!this.whitelistedJarPatterns.isEmpty()) {
                log.log("Whitelisted jars with glob wildcards:  " + this.whitelistedJarPatterns);
            }
            if (!this.blacklistedJars.isEmpty()) {
                log.log("Blacklisted jars:  " + this.blacklistedJars);
            }
            if (!this.blacklistedJarPatterns.isEmpty()) {
                log.log("Whitelisted jars with glob wildcards:  " + this.blacklistedJarPatterns);
            }
            if (!this.specificallyWhitelistedClassRelativePaths.isEmpty()) {
                log.log("Specifically-whitelisted classfiles: " + this.specificallyWhitelistedClassRelativePaths);
            }
            if (!this.specificallyBlacklistedClassRelativePaths.isEmpty()) {
                log.log("Specifically-blacklisted classfiles: " + this.specificallyBlacklistedClassRelativePaths);
            }
            if (!scanJars) {
                log.log("Scanning of jarfiles is disabled");
            }
            if (!scanNonJars) {
                log.log("Scanning of directories (i.e. non-jarfiles) is disabled");
            }
        }
        this.classLoaders = ScanSpec.findAllClassLoaders(log == null ? null : log.log("Finding ClassLoaders"));
    }

    private static void addAllParentClassloaders(ClassLoader classLoader, AdditionOrderedSet<ClassLoader> classLoadersSetOut) {
        ArrayList<ClassLoader> callerClassLoaders = new ArrayList<ClassLoader>();
        for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
            callerClassLoaders.add(cl);
        }
        for (int i = callerClassLoaders.size() - 1; i >= 0; --i) {
            classLoadersSetOut.add((ClassLoader)callerClassLoaders.get(i));
        }
    }

    private static void addAllParentClassloaders(Class<?> klass, AdditionOrderedSet<ClassLoader> classLoadersSetOut) {
        ScanSpec.addAllParentClassloaders(klass.getClassLoader(), classLoadersSetOut);
    }

    private static List<ClassLoader> findAllClassLoaders(LogNode log) {
        AdditionOrderedSet<ClassLoader> classLoadersSet = new AdditionOrderedSet<ClassLoader>();
        ScanSpec.addAllParentClassloaders(ClassLoader.getSystemClassLoader(), classLoadersSet);
        if (CALLER_RESOLVER != null) {
            Class<?>[] callStack = CALLER_RESOLVER.getClassContext();
            for (Class<?> callStackClass : callStack) {
                ScanSpec.addAllParentClassloaders(callStackClass, classLoadersSet);
            }
        } else if (log != null) {
            log.log(ClasspathFinder.class.getSimpleName() + " could not create " + CallerResolver.class.getSimpleName() + ", current SecurityManager does not grant RuntimePermission(\"createSecurityManager\")");
        }
        ScanSpec.addAllParentClassloaders(Thread.currentThread().getContextClassLoader(), classLoadersSet);
        ScanSpec.addAllParentClassloaders(ClasspathFinder.class, classLoadersSet);
        List<ClassLoader> classLoaders = classLoadersSet.getList();
        classLoaders.remove(null);
        if (log != null) {
            for (ClassLoader classLoader : classLoaders) {
                log.log("Found ClassLoader " + classLoader.toString());
            }
            log.addElapsedTime();
        }
        return classLoaders;
    }

    void callMatchProcessors(ScanResult scanResult, List<ClasspathElement> classpathOrder, Map<String, ClassInfo> classNameToClassInfo, InterruptionChecker interruptionChecker, LogNode log) throws InterruptedException, ExecutionException {
        for (ClasspathElement classpathElement : classpathOrder) {
            if (classpathElement.fileMatches == null || classpathElement.fileMatches.isEmpty()) continue;
            classpathElement.callFileMatchProcessors(log == null ? null : log.log("Calling FileMatchProcessor for classpath element " + classpathElement));
        }
        if (this.classMatchers != null) {
            for (ClassMatcher classMatcher : this.classMatchers) {
                block13: {
                    try {
                        classMatcher.lookForMatches(scanResult, log == null ? null : log.log("Calling ClassMatchProcessors"));
                    }
                    catch (Throwable e) {
                        if (log == null) break block13;
                        log.log("Exception while calling ClassMatchProcessor: " + e);
                    }
                }
                interruptionChecker.check();
            }
        }
        if (this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors != null) {
            for (Map.Entry entry : this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.getRawMap().entrySet()) {
                int dotIdx;
                String fullyQualifiedFieldName = (String)entry.getKey();
                String className = fullyQualifiedFieldName.substring(0, dotIdx = fullyQualifiedFieldName.lastIndexOf(46));
                ClassInfo classInfo = classNameToClassInfo.get(className);
                if (classInfo != null) {
                    String fieldName = fullyQualifiedFieldName.substring(dotIdx + 1);
                    Object constValue = classInfo.getStaticFinalFieldConstantInitializerValue(fieldName);
                    if (constValue == null) {
                        if (log == null) continue;
                        log.log("No constant initializer value found for field " + className + "." + fieldName);
                        continue;
                    }
                    List staticFinalFieldMatchProcessors = (List)entry.getValue();
                    if (log != null) {
                        log.log("Calling MatchProcessor" + (staticFinalFieldMatchProcessors.size() == 1 ? "" : "s") + " for static final field " + className + "." + fieldName + " = " + (constValue instanceof Character ? '\'' + constValue.toString().replace("'", "\\'") + '\'' : (constValue instanceof String ? '\"' + constValue.toString().replace("\"", "\\\"") + '\"' : constValue.toString())));
                    }
                    for (StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor : (List)entry.getValue()) {
                        block14: {
                            try {
                                staticFinalFieldMatchProcessor.processMatch(className, fieldName, constValue);
                            }
                            catch (Throwable e) {
                                if (log == null) break block14;
                                log.log("Exception while calling StaticFinalFieldMatchProcessor: " + e);
                            }
                        }
                        interruptionChecker.check();
                    }
                    continue;
                }
                if (log == null) continue;
                log.log("No matching class found in scan results for static final field " + fullyQualifiedFieldName);
            }
        }
    }

    private static Pattern specToPattern(String spec) {
        return Pattern.compile("^" + spec.replace(".", "\\.").replace("*", ".*") + "$");
    }

    ScanSpecPathMatch pathWhitelistMatchStatus(String relativePath) {
        for (String blacklistedPath : this.blacklistedPathPrefixes) {
            if (!relativePath.startsWith(blacklistedPath)) continue;
            return ScanSpecPathMatch.WITHIN_BLACKLISTED_PATH;
        }
        for (String whitelistedPath : this.whitelistedPathPrefixes) {
            if (relativePath.startsWith(whitelistedPath)) {
                return ScanSpecPathMatch.WITHIN_WHITELISTED_PATH;
            }
            if (!whitelistedPath.startsWith(relativePath) && !"/".equals(relativePath)) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        if (this.specificallyWhitelistedClassParentRelativePaths.contains(relativePath) && !this.specificallyBlacklistedClassRelativePaths.contains(relativePath)) {
            return ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE;
        }
        for (String whitelistedClassPathPrefix : this.specificallyWhitelistedClassParentRelativePaths) {
            if (!whitelistedClassPathPrefix.startsWith(relativePath) && !"/".equals(relativePath)) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        return ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH;
    }

    boolean isSpecificallyWhitelistedClass(String relativePath) {
        return this.specificallyWhitelistedClassRelativePaths.contains(relativePath) && !this.specificallyBlacklistedClassRelativePaths.contains(relativePath);
    }

    boolean classIsBlacklisted(String className) {
        boolean classIsBlacklisted = false;
        if (this.specificallyBlacklistedClassNames.contains(className)) {
            classIsBlacklisted = true;
        } else {
            for (String blacklistedPackagePrefix : this.blacklistedPackagePrefixes) {
                if (!className.startsWith(blacklistedPackagePrefix)) continue;
                classIsBlacklisted = true;
                break;
            }
        }
        return classIsBlacklisted;
    }

    synchronized void checkClassIsNotBlacklisted(String className) {
        if (this.strictWhitelist && this.classIsBlacklisted(className)) {
            boolean isSystemPackage = className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.");
            throw new IllegalArgumentException("Can't scan for " + className + ", it is in a blacklisted " + (!isSystemPackage ? "package" : "system package") + ", and and strictWhitelist() was called before scan()." + (!isSystemPackage ? "" : "You can override this by adding \"!\" or \"!!\" to the scan spec to disable system package blacklisting or system jar blacklisting respectively (see the docs)"));
        }
    }

    private static boolean containsJarName(HashSet<String> jarNames, ArrayList<Pattern> jarNamePatterns, String jarName) {
        if (jarNames.contains(jarName)) {
            return true;
        }
        for (Pattern jarNamePattern : jarNamePatterns) {
            if (!jarNamePattern.matcher(jarName).matches()) continue;
            return true;
        }
        return false;
    }

    boolean jarIsWhitelisted(String jarName) {
        return (this.whitelistedJars.isEmpty() && this.whitelistedJarPatterns.isEmpty() || ScanSpec.containsJarName(this.whitelistedJars, this.whitelistedJarPatterns, jarName)) && !ScanSpec.containsJarName(this.blacklistedJars, this.blacklistedJarPatterns, jarName);
    }

    boolean blacklistSystemJars() {
        return this.blacklistSystemJars;
    }

    private synchronized <T> Class<? extends T> loadClass(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return cls;
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError e) {
            throw new RuntimeException("Exception while loading or initializing class " + className, e);
        }
    }

    synchronized String getAnnotationName(Class<?> annotation) {
        String annotationName = annotation.getName();
        this.checkClassIsNotBlacklisted(annotationName);
        if (!annotation.isAnnotation()) {
            throw new IllegalArgumentException(annotationName + " is not an annotation");
        }
        return annotation.getName();
    }

    synchronized String[] getAnnotationNames(Class<?>[] annotations) {
        String[] annotationNames = new String[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            annotationNames[i] = this.getAnnotationName(annotations[i]);
        }
        return annotationNames;
    }

    synchronized String getInterfaceName(Class<?> iface) {
        String ifaceName = iface.getName();
        this.checkClassIsNotBlacklisted(ifaceName);
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(ifaceName + " is not an interface");
        }
        return iface.getName();
    }

    synchronized String[] getInterfaceNames(Class<?>[] interfaces) {
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = this.getInterfaceName(interfaces[i]);
        }
        return interfaceNames;
    }

    synchronized String getClassOrInterfaceName(Class<?> classOrInterface) {
        String classOrIfaceName = classOrInterface.getName();
        this.checkClassIsNotBlacklisted(classOrIfaceName);
        if (classOrInterface.isAnnotation()) {
            throw new IllegalArgumentException(classOrIfaceName + " is an annotation, not a regular class or interface");
        }
        return classOrInterface.getName();
    }

    synchronized String getStandardClassName(Class<?> cls) {
        String className = cls.getName();
        this.checkClassIsNotBlacklisted(className);
        if (cls.isAnnotation()) {
            throw new IllegalArgumentException(className + " is an annotation, not a standard class");
        }
        if (cls.isInterface()) {
            throw new IllegalArgumentException(cls.getName() + " is an interface, not a standard class");
        }
        return className;
    }

    private synchronized String getClassName(Class<?> cls) {
        String className = cls.getName();
        this.checkClassIsNotBlacklisted(className);
        return className;
    }

    public synchronized void matchAllClasses(final ClassMatchProcessor classMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllClasses()) {
                    if (log != null) {
                        log.log("Matched class: " + className);
                    }
                    Class cls = ScanSpec.this.loadClass(className);
                    classMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized void matchAllStandardClasses(final ClassMatchProcessor classMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllStandardClasses()) {
                    if (log != null) {
                        log.log("Matched standard class: " + className);
                    }
                    Class cls = ScanSpec.this.loadClass(className);
                    classMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized void matchAllInterfaceClasses(final ClassMatchProcessor ClassMatchProcessor2) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllInterfaceClasses()) {
                    if (log != null) {
                        log.log("Matched interface class: " + className);
                    }
                    Class cls = ScanSpec.this.loadClass(className);
                    ClassMatchProcessor2.processMatch(cls);
                }
            }
        });
    }

    public synchronized void matchAllAnnotationClasses(final ClassMatchProcessor ClassMatchProcessor2) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllAnnotationClasses()) {
                    if (log != null) {
                        log.log("Matched annotation class: " + className);
                    }
                    Class cls = ScanSpec.this.loadClass(className);
                    ClassMatchProcessor2.processMatch(cls);
                }
            }
        });
    }

    public synchronized <T> void matchSubclassesOf(final Class<T> superclass, final SubclassMatchProcessor<T> subclassMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String superclassName = ScanSpec.this.getStandardClassName(superclass);
                for (String subclassName : scanResult.getNamesOfSubclassesOf(superclassName)) {
                    if (log != null) {
                        log.log("Matched subclass of " + superclassName + ": " + subclassName);
                    }
                    Class cls = ScanSpec.this.loadClass(subclassName);
                    subclassMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized <T> void matchSubinterfacesOf(final Class<T> superinterface, final SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String superinterfaceName = ScanSpec.this.getInterfaceName(superinterface);
                for (String subinterfaceName : scanResult.getNamesOfSubinterfacesOf(superinterfaceName)) {
                    if (log != null) {
                        log.log("Matched subinterface of " + superinterfaceName + ": " + subinterfaceName);
                    }
                    Class cls = ScanSpec.this.loadClass(subinterfaceName);
                    subinterfaceMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized <T> void matchClassesImplementing(final Class<T> implementedInterface, final ImplementingClassMatchProcessor<T> interfaceMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String implementedInterfaceName = ScanSpec.this.getInterfaceName(implementedInterface);
                for (String implClass : scanResult.getNamesOfClassesImplementing(implementedInterfaceName)) {
                    if (log != null) {
                        log.log("Matched class implementing interface " + implementedInterfaceName + ": " + implClass);
                    }
                    Class cls = ScanSpec.this.loadClass(implClass);
                    interfaceMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized <T> void matchClassesWithFieldOfType(final Class<T> fieldType, final ClassMatchProcessor classMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String fieldTypeName = ScanSpec.this.getClassName(fieldType);
                for (String klass : scanResult.getNamesOfClassesWithFieldOfType(fieldTypeName)) {
                    if (log != null) {
                        log.log("Matched class with field of type " + fieldTypeName + ": " + klass);
                    }
                    Class cls = ScanSpec.this.loadClass(klass);
                    classMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized void matchClassesWithAnnotation(final Class<?> annotation, final ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String annotationName = ScanSpec.this.getAnnotationName(annotation);
                for (String classWithAnnotation : scanResult.getNamesOfClassesWithAnnotation(annotationName)) {
                    if (log != null) {
                        log.log("Matched class with annotation " + annotationName + ": " + classWithAnnotation);
                    }
                    Class cls = ScanSpec.this.loadClass(classWithAnnotation);
                    classAnnotationMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    private synchronized void addStaticFinalFieldProcessor(String className, String fieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        String fullyQualifiedFieldName = className + "." + fieldName;
        if (this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors == null) {
            this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors = new MultiMapKeyToList();
            this.classNameToStaticFinalFieldsToMatch = new MultiMapKeyToSet();
        }
        this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.put(fullyQualifiedFieldName, staticFinalFieldMatchProcessor);
        this.classNameToStaticFinalFieldsToMatch.put(className, fieldName);
    }

    public synchronized void matchStaticFinalFieldNames(Set<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            int lastDotIdx = fullyQualifiedFieldName.lastIndexOf(46);
            if (lastDotIdx <= 0) continue;
            String className = fullyQualifiedFieldName.substring(0, lastDotIdx);
            String fieldName = fullyQualifiedFieldName.substring(lastDotIdx + 1);
            this.addStaticFinalFieldProcessor(className, fieldName, staticFinalFieldMatchProcessor);
        }
    }

    public synchronized void matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedStaticFinalFieldName);
        this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    public synchronized void matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedFieldName);
        }
        this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    private void addFilePathMatcher(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
        this.filePathTestersAndMatchProcessorWrappers.add(new FilePathTesterAndMatchProcessorWrapper(filePathTester, fileMatchProcessorWrapper));
    }

    List<FilePathTesterAndMatchProcessorWrapper> getFilePathTestersAndMatchProcessorWrappers() {
        return this.filePathTestersAndMatchProcessorWrappers;
    }

    private static byte[] readAllBytes(InputStream inputStream, long fileSize) throws IOException {
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOException("File larger that 2GB, cannot read contents into a Java array");
        }
        byte[] bytes = new byte[(int)fileSize];
        int bytesRead = inputStream.read(bytes);
        if ((long)bytesRead < fileSize) {
            throw new IOException("Could not read whole file");
        }
        return bytes;
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchProcessor fileMatchProcessor) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchProcessor.processMatch(relativePath, inputStream, fileSize);
            }
        };
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchProcessorWithContext.processMatch(classpathElt, relativePath, inputStream, fileSize);
            }
        };
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchContentsProcessor fileMatchContentsProcessor) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchContentsProcessor.processMatch(relativePath, ScanSpec.readAllBytes(inputStream, fileSize));
            }
        };
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchContentsProcessorWithContext.processMatch(classpathElt, relativePath, ScanSpec.readAllBytes(inputStream, fileSize));
            }
        };
    }

    private FilePathTester makeFilePathTesterMatchingRegexp(final String pathRegexp) {
        return new FilePathTester(){
            private final Pattern pattern;
            {
                this.pattern = Pattern.compile(pathRegexp);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr, LogNode log) {
                boolean matched = this.pattern.matcher(relativePathStr).matches();
                if (matched && log != null) {
                    log.log("File " + relativePathStr + " matched filename pattern " + pathRegexp);
                }
                return matched;
            }
        };
    }

    public synchronized void matchFilenamePattern(String pathRegexp, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public synchronized void matchFilenamePattern(String pathRegexp, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    public synchronized void matchFilenamePattern(String pathRegexp, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public synchronized void matchFilenamePattern(String pathRegexp, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    private FilePathTester makeFilePathTesterMatchingRelativePath(final String relativePathToMatch) {
        return new FilePathTester(){

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr, LogNode log) {
                boolean matched = relativePathStr.equals(relativePathToMatch);
                if (matched && log != null) {
                    log.log("Matched filename path " + relativePathToMatch);
                }
                return matched;
            }
        };
    }

    public synchronized void matchFilenamePath(String relativePathToMatch, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public synchronized void matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    public synchronized void matchFilenamePath(String relativePathToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public synchronized void matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    private FilePathTester makeFilePathTesterMatchingPathLeaf(final String pathLeafToMatch) {
        return new FilePathTester(){
            private final String leafToMatch;
            {
                this.leafToMatch = pathLeafToMatch.substring(pathLeafToMatch.lastIndexOf(47) + 1);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr, LogNode log) {
                String relativePathLeaf = relativePathStr.substring(relativePathStr.lastIndexOf(47) + 1);
                boolean matched = relativePathLeaf.equals(this.leafToMatch);
                if (matched && log != null) {
                    log.log("File " + relativePathStr + " matched path leaf " + pathLeafToMatch);
                }
                return matched;
            }
        };
    }

    public synchronized void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public synchronized void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    public synchronized void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public synchronized void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    private FilePathTester makeFilePathTesterMatchingFilenameExtension(final String extensionToMatch) {
        return new FilePathTester(){
            final int extLen;
            {
                this.extLen = extensionToMatch.length();
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePath, LogNode log) {
                boolean matched;
                int relativePathLen = relativePath.length();
                int extIdx = relativePathLen - this.extLen;
                boolean bl = matched = relativePathLen > this.extLen + 1 && relativePath.charAt(extIdx - 1) == '.' && relativePath.regionMatches(true, extIdx, extensionToMatch, 0, this.extLen);
                if (matched && log != null) {
                    log.log("File " + relativePath + " matched extension ." + extensionToMatch);
                }
                return matched;
            }
        };
    }

    public synchronized void matchFilenameExtension(String extensionToMatch, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public synchronized void matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    public synchronized void matchFilenameExtension(String extensionToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public synchronized void matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static class FilePathTesterAndMatchProcessorWrapper {
        private final FilePathTester filePathTester;
        FileMatchProcessorWrapper fileMatchProcessorWrapper;

        private FilePathTesterAndMatchProcessorWrapper(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
            this.filePathTester = filePathTester;
            this.fileMatchProcessorWrapper = fileMatchProcessorWrapper;
        }

        boolean filePathMatches(File classpathElt, String relativePathStr, LogNode log) {
            return this.filePathTester.filePathMatches(classpathElt, relativePathStr, log);
        }
    }

    static interface FileMatchProcessorWrapper {
        public void processMatch(File var1, String var2, InputStream var3, long var4) throws IOException;
    }

    private static interface FilePathTester {
        public boolean filePathMatches(File var1, String var2, LogNode var3);
    }

    static enum ScanSpecPathMatch {
        WITHIN_BLACKLISTED_PATH,
        WITHIN_WHITELISTED_PATH,
        ANCESTOR_OF_WHITELISTED_PATH,
        AT_WHITELISTED_CLASS_PACKAGE,
        NOT_WITHIN_WHITELISTED_PATH;

    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }

    private static interface ClassMatcher {
        public void lookForMatches(ScanResult var1, LogNode var2);
    }
}

