/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.EquinoxClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.JBossClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.URLClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.WeblogicClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClasspathFinder {
    private final List<String> rawClasspathElements = new ArrayList<String>();
    private static final List<Class<? extends ClassLoaderHandler>> DEFAULT_CLASS_LOADER_HANDLERS = Arrays.asList(URLClassLoaderHandler.class, EquinoxClassLoaderHandler.class, JBossClassLoaderHandler.class, WeblogicClassLoaderHandler.class);

    public void addClasspathElement(String pathElement, LogNode log) {
        this.rawClasspathElements.add(pathElement);
        if (log != null) {
            log.log("Adding classpath element: " + pathElement);
        }
    }

    public void addClasspathElements(String pathStr, LogNode log) {
        if (pathStr != null && !pathStr.isEmpty()) {
            for (String pathElement : pathStr.split(File.pathSeparator)) {
                this.addClasspathElement(pathElement, log);
            }
        }
    }

    ClasspathFinder(ScanSpec scanSpec, LogNode log) {
        if (scanSpec.overrideClasspath != null) {
            LogNode overrideLog = log == null ? null : log.log("Overriding classpath");
            this.addClasspathElements(scanSpec.overrideClasspath, overrideLog);
        } else {
            ArrayList<ClassLoaderHandler> classLoaderHandlers = new ArrayList<ClassLoaderHandler>();
            for (Class<? extends ClassLoaderHandler> clazz : DEFAULT_CLASS_LOADER_HANDLERS) {
                try {
                    classLoaderHandlers.add(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    if (log == null) continue;
                    log.log("Could not instantiate " + clazz.getName(), e);
                }
            }
            for (Class<? extends ClassLoaderHandler> clazz : scanSpec.extraClassLoaderHandlers) {
                try {
                    classLoaderHandlers.add(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    if (log == null) continue;
                    log.log("Could not instantiate " + clazz.getName(), e);
                }
            }
            if (log != null) {
                LogNode classLoaderHandlerLog = log.log("ClassLoaderHandlers loaded:");
                for (ClassLoaderHandler classLoaderHandler : classLoaderHandlers) {
                    classLoaderHandlerLog.log(classLoaderHandler.getClass().getName());
                }
            }
            for (ClassLoader classLoader : scanSpec.classLoaders) {
                LogNode classLoaderLog = log == null ? null : log.log("Finding classpath elements in ClassLoader " + classLoader);
                boolean classloaderFound = false;
                for (ClassLoaderHandler handler : classLoaderHandlers) {
                    try {
                        if (!handler.handle(classLoader, this, classLoaderLog)) continue;
                        classloaderFound = true;
                        break;
                    }
                    catch (Exception e) {
                        if (classLoaderLog == null) continue;
                        classLoaderLog.log("Exception in ClassLoaderHandler", e);
                    }
                }
                if (classloaderFound || classLoaderLog == null) continue;
                classLoaderLog.log("Unknown ClassLoader type, cannot scan classes");
            }
            LogNode sysPropLog = log == null ? null : log.log("Getting classpath entries from java.class.path");
            this.addClasspathElements(System.getProperty("java.class.path"), sysPropLog);
        }
    }

    public List<String> getRawClasspathElements() {
        return this.rawClasspathElements;
    }
}

