/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClassGraphBuilder {
    private final Map<String, ClassInfo> classNameToClassInfo;
    private final ScanSpec scanSpec;
    private final Set<ClassInfo> allClassInfo;

    ClassGraphBuilder(ScanSpec scanSpec, Map<String, ClassInfo> classNameToClassInfo) {
        this.scanSpec = scanSpec;
        this.classNameToClassInfo = classNameToClassInfo;
        this.allClassInfo = new HashSet<ClassInfo>(classNameToClassInfo.values());
    }

    Map<String, ClassInfo> getClassNameToClassInfo() {
        return this.classNameToClassInfo;
    }

    List<String> getNamesOfAllClasses() {
        return ClassInfo.getNamesOfAllClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfAllStandardClasses() {
        return ClassInfo.getNamesOfAllStandardClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfSubclassesOf(String className) {
        ClassInfo classInfo = this.classNameToClassInfo.get(className);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfSubclasses();
    }

    List<String> getNamesOfSuperclassesOf(String className) {
        ClassInfo classInfo = this.classNameToClassInfo.get(className);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfSuperclasses();
    }

    List<String> getNamesOfClassesWithFieldOfType(String fieldTypeName) {
        return ClassInfo.getNamesOfClassesWithFieldOfType(fieldTypeName, this.allClassInfo);
    }

    List<String> getNamesOfAllInterfaceClasses() {
        return ClassInfo.getNamesOfAllInterfaceClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(interfaceName);
        if (classInfo == null) {
            return null;
        }
        return classInfo.getNamesOfSubinterfaces();
    }

    List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(interfaceName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfSuperinterfaces();
    }

    List<String> getNamesOfClassesImplementing(String interfaceName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(interfaceName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfClassesImplementing();
    }

    List<String> getNamesOfAllAnnotationClasses() {
        return ClassInfo.getNamesOfAllAnnotationClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(annotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfClassesWithAnnotation();
    }

    List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceOrAnnotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(classOrInterfaceOrAnnotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfAnnotations();
    }

    List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(annotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfMetaAnnotations();
    }

    List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(metaAnnotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfAnnotationsWithMetaAnnotation();
    }

    String generateClassGraphDotFile(float sizeX, float sizeY) {
        return ClassInfo.generateClassGraphDotFile(this.scanSpec, this.allClassInfo, sizeX, sizeY);
    }
}

