/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lognet.springboot.grpc.GRpcServicesRegistry;
import org.lognet.springboot.grpc.security.SecurityInterceptor;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.method.MethodSecurityMetadataSource;

public class GrpcSecurityMetadataSource
implements MethodSecurityMetadataSource {
    private Map<MethodDescriptor<?, ?>, List<ConfigAttribute>> methodDescriptorAttributes;
    private GRpcServicesRegistry registry;

    public GrpcSecurityMetadataSource(GRpcServicesRegistry registry, Map<MethodDescriptor<?, ?>, List<ConfigAttribute>> methodDescriptorAttributes) {
        this.methodDescriptorAttributes = methodDescriptorAttributes;
        this.registry = registry;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        MethodDescriptor methodDescriptor = ((SecurityInterceptor.GrpcMethodInvocation)((Object)SecurityInterceptor.GrpcMethodInvocation.class.cast(object))).getCall().getMethodDescriptor();
        return this.methodDescriptorAttributes.get(methodDescriptor);
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return this.methodDescriptorAttributes.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean supports(Class<?> clazz) {
        return SecurityInterceptor.GrpcMethodInvocation.class.isAssignableFrom(clazz);
    }

    public Collection<ConfigAttribute> getAttributes(Method method, Class<?> targetClass) {
        MethodDescriptor<?, ?> methodDescriptor = this.registry.getMethodDescriptor(method);
        return this.methodDescriptorAttributes.get(methodDescriptor);
    }
}

