/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.recovery;

import java.util.Optional;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public final class GRpcRuntimeExceptionWrapper
extends RuntimeException {
    private Object hint;

    public GRpcRuntimeExceptionWrapper(@NonNull Throwable cause, Object hint) {
        this(cause);
        this.hint = hint;
    }

    public GRpcRuntimeExceptionWrapper(@NonNull Throwable cause) {
        super(null, cause);
        Assert.notNull((Object)cause, () -> "Cause can't be null");
    }

    public static Throwable unwrap(Throwable exc) {
        return Optional.ofNullable(exc).filter(GRpcRuntimeExceptionWrapper.class::isInstance).map(Throwable::getCause).orElse(exc);
    }

    public static Object getHint(Throwable exc) {
        return Optional.ofNullable(exc).filter(GRpcRuntimeExceptionWrapper.class::isInstance).map(GRpcRuntimeExceptionWrapper.class::cast).map(w -> w.getHint()).orElse(null);
    }

    public Object getHint() {
        return this.hint;
    }
}

