/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.recovery;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.lognet.springboot.grpc.FailureHandlingSupport;
import org.lognet.springboot.grpc.MessageBlockingServerCallListener;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.recovery.GRpcExceptionHandlerMethodResolver;
import org.springframework.core.Ordered;

public class GRpcExceptionHandlerInterceptor
implements ServerInterceptor,
Ordered {
    private final GRpcExceptionHandlerMethodResolver methodResolver;
    private final FailureHandlingSupport failureHandlingSupport;
    private Integer order;

    public GRpcExceptionHandlerInterceptor(GRpcExceptionHandlerMethodResolver methodResolver, FailureHandlingSupport failureHandlingSupport, GRpcServerProperties serverProperties) {
        this.methodResolver = methodResolver;
        this.failureHandlingSupport = failureHandlingSupport;
        this.order = Optional.ofNullable(serverProperties.getRecovery()).map(GRpcServerProperties.RecoveryProperties::getInterceptorOrder).orElse(Integer.MIN_VALUE);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, final Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ServerCall.Listener listener;
        final AtomicBoolean callIsClosed = new AtomicBoolean(false);
        if (!this.methodResolver.hasErrorHandlers()) {
            return next.startCall(call, headers);
        }
        final ForwardingServerCall.SimpleForwardingServerCall errorHandlingCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void close(Status status, Metadata trailers) {
                if (callIsClosed.compareAndSet(false, true)) {
                    super.close(status, trailers);
                }
            }

            public void sendMessage(RespT message) {
                try {
                    super.sendMessage(message);
                }
                catch (RuntimeException e) {
                    GRpcExceptionHandlerInterceptor.this.failureHandlingSupport.closeCall(e, (ServerCall<?, ?>)this, headers, b -> b.response(message));
                }
            }
        };
        try {
            listener = next.startCall((ServerCall)errorHandlingCall, headers);
        }
        catch (RuntimeException e) {
            this.failureHandlingSupport.closeCall(e, (ServerCall<?, ?>)errorHandlingCall, headers);
            return new ServerCall.Listener<ReqT>(){};
        }
        return new MessageBlockingServerCallListener<ReqT>(listener){
            private ReqT request;

            public void onMessage(ReqT message) {
                try {
                    this.request = message;
                    super.onMessage(message);
                }
                catch (RuntimeException e) {
                    this.blockMessage();
                    GRpcExceptionHandlerInterceptor.this.failureHandlingSupport.closeCall(e, (ServerCall<?, ?>)errorHandlingCall, headers, b -> b.request(this.request));
                }
            }

            @Override
            public void onHalfClose() {
                try {
                    if (!callIsClosed.get()) {
                        super.onHalfClose();
                    }
                }
                catch (RuntimeException e) {
                    GRpcExceptionHandlerInterceptor.this.failureHandlingSupport.closeCall(e, (ServerCall<?, ?>)errorHandlingCall, headers, b -> b.request(this.request));
                }
            }
        };
    }

    public int getOrder() {
        return this.order;
    }
}

