// Generated by delombok at Tue Jun 14 13:32:34 UTC 2022
package org.lognet.springboot.grpc.autoconfigure;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.io.Resource;
import org.springframework.util.SocketUtils;
import org.springframework.util.unit.DataSize;

/** Created by alexf on 26-Jan-16. */
@ConfigurationProperties("grpc")
public class GRpcServerProperties {
  public static final int DEFAULT_GRPC_PORT = 6565;
  /** gRPC server port */
  private Integer port = null;

  private SecurityProperties security;
  private RecoveryProperties recovery;
  private NettyServerProperties nettyServer;
  private volatile Integer runningPort = null;
  private int startUpPhase = SmartLifecycle.DEFAULT_PHASE;
  /** Enables the embedded grpc server. */
  private boolean enabled = true;
  /**
   * In process server name. If the value is not empty, the embedded in-process server will be
   * created and started.
   */
  private String inProcessServerName;
  /**
   * Enables server reflection using <a
   * href="https://github.com/grpc/grpc-java/blob/master/documentation/server-reflection-tutorial.md">ProtoReflectionService</a>.
   * Available only from gRPC 1.3 or higher.
   */
  private boolean enableReflection = false;
  /**
   * Number of seconds to wait for preexisting calls to finish before shutting down. A negative
   * value is equivalent to an infinite grace period
   */
  private int shutdownGrace = 0;

  public Integer getRunningPort() {
    if (null == runningPort) {
      synchronized (this) {
        if (null == runningPort) {
          runningPort =
              Optional.ofNullable(port)
                  .map(p -> 0 == p ? SocketUtils.findAvailableTcpPort() : p)
                  .orElse(DEFAULT_GRPC_PORT);
        }
      }
    }
    return runningPort;
  }

  public static class RecoveryProperties {
    private Integer interceptorOrder;

    @java.lang.SuppressWarnings("all")
    public Integer getInterceptorOrder() {
      return this.interceptorOrder;
    }

    @java.lang.SuppressWarnings("all")
    public void setInterceptorOrder(final Integer interceptorOrder) {
      this.interceptorOrder = interceptorOrder;
    }
  }

  public static class SecurityProperties {
    private Resource certChain;
    private Resource privateKey;
    private Auth auth;

    public static class Auth {
      private Integer interceptorOrder;
      private boolean failFast = true;

      @java.lang.SuppressWarnings("all")
      public Integer getInterceptorOrder() {
        return this.interceptorOrder;
      }

      @java.lang.SuppressWarnings("all")
      public boolean isFailFast() {
        return this.failFast;
      }

      @java.lang.SuppressWarnings("all")
      public void setInterceptorOrder(final Integer interceptorOrder) {
        this.interceptorOrder = interceptorOrder;
      }

      @java.lang.SuppressWarnings("all")
      public void setFailFast(final boolean failFast) {
        this.failFast = failFast;
      }
    }

    @java.lang.SuppressWarnings("all")
    public Resource getCertChain() {
      return this.certChain;
    }

    @java.lang.SuppressWarnings("all")
    public Resource getPrivateKey() {
      return this.privateKey;
    }

    @java.lang.SuppressWarnings("all")
    public Auth getAuth() {
      return this.auth;
    }

    @java.lang.SuppressWarnings("all")
    public void setCertChain(final Resource certChain) {
      this.certChain = certChain;
    }

    @java.lang.SuppressWarnings("all")
    public void setPrivateKey(final Resource privateKey) {
      this.privateKey = privateKey;
    }

    @java.lang.SuppressWarnings("all")
    public void setAuth(final Auth auth) {
      this.auth = auth;
    }
  }

  public static class NettyServerProperties {
    private boolean onCollisionPreferShadedNetty;
    private Integer flowControlWindow;
    private Integer initialFlowControlWindow;
    private Integer maxConcurrentCallsPerConnection;
    private Duration keepAliveTime;
    private Duration keepAliveTimeout;
    private Duration maxConnectionAge;
    private Duration maxConnectionAgeGrace;
    private Duration maxConnectionIdle;
    private Duration permitKeepAliveTime;
    private DataSize maxInboundMessageSize;
    private DataSize maxInboundMetadataSize;
    private Boolean permitKeepAliveWithoutCalls;
    /**
     * grpc listen address.
     *
     * <p>If configured, takes precedence over {@code grpc.port} property value. Supported format:
     *
     * <ul>
     *   <li>{@code host:port} (if port is less than 1, uses random value)
     *   <li>{@code host:} (uses default grpc port, 6565 )
     * </ul>
     */
    private InetSocketAddress primaryListenAddress;

    private List<InetSocketAddress> additionalListenAddresses;

    @java.lang.SuppressWarnings("all")
    public boolean isOnCollisionPreferShadedNetty() {
      return this.onCollisionPreferShadedNetty;
    }

    @java.lang.SuppressWarnings("all")
    public Integer getFlowControlWindow() {
      return this.flowControlWindow;
    }

    @java.lang.SuppressWarnings("all")
    public Integer getInitialFlowControlWindow() {
      return this.initialFlowControlWindow;
    }

    @java.lang.SuppressWarnings("all")
    public Integer getMaxConcurrentCallsPerConnection() {
      return this.maxConcurrentCallsPerConnection;
    }

    @java.lang.SuppressWarnings("all")
    public Duration getKeepAliveTime() {
      return this.keepAliveTime;
    }

    @java.lang.SuppressWarnings("all")
    public Duration getKeepAliveTimeout() {
      return this.keepAliveTimeout;
    }

    @java.lang.SuppressWarnings("all")
    public Duration getMaxConnectionAge() {
      return this.maxConnectionAge;
    }

    @java.lang.SuppressWarnings("all")
    public Duration getMaxConnectionAgeGrace() {
      return this.maxConnectionAgeGrace;
    }

    @java.lang.SuppressWarnings("all")
    public Duration getMaxConnectionIdle() {
      return this.maxConnectionIdle;
    }

    @java.lang.SuppressWarnings("all")
    public Duration getPermitKeepAliveTime() {
      return this.permitKeepAliveTime;
    }

    @java.lang.SuppressWarnings("all")
    public DataSize getMaxInboundMessageSize() {
      return this.maxInboundMessageSize;
    }

    @java.lang.SuppressWarnings("all")
    public DataSize getMaxInboundMetadataSize() {
      return this.maxInboundMetadataSize;
    }

    @java.lang.SuppressWarnings("all")
    public Boolean getPermitKeepAliveWithoutCalls() {
      return this.permitKeepAliveWithoutCalls;
    }

    /**
     * grpc listen address.
     *
     * <p>If configured, takes precedence over {@code grpc.port} property value. Supported format:
     *
     * <ul>
     *   <li>{@code host:port} (if port is less than 1, uses random value)
     *   <li>{@code host:} (uses default grpc port, 6565 )
     * </ul>
     */
    @java.lang.SuppressWarnings("all")
    public InetSocketAddress getPrimaryListenAddress() {
      return this.primaryListenAddress;
    }

    @java.lang.SuppressWarnings("all")
    public List<InetSocketAddress> getAdditionalListenAddresses() {
      return this.additionalListenAddresses;
    }

    @java.lang.SuppressWarnings("all")
    public void setOnCollisionPreferShadedNetty(final boolean onCollisionPreferShadedNetty) {
      this.onCollisionPreferShadedNetty = onCollisionPreferShadedNetty;
    }

    @java.lang.SuppressWarnings("all")
    public void setFlowControlWindow(final Integer flowControlWindow) {
      this.flowControlWindow = flowControlWindow;
    }

    @java.lang.SuppressWarnings("all")
    public void setInitialFlowControlWindow(final Integer initialFlowControlWindow) {
      this.initialFlowControlWindow = initialFlowControlWindow;
    }

    @java.lang.SuppressWarnings("all")
    public void setMaxConcurrentCallsPerConnection(final Integer maxConcurrentCallsPerConnection) {
      this.maxConcurrentCallsPerConnection = maxConcurrentCallsPerConnection;
    }

    @java.lang.SuppressWarnings("all")
    public void setKeepAliveTime(final Duration keepAliveTime) {
      this.keepAliveTime = keepAliveTime;
    }

    @java.lang.SuppressWarnings("all")
    public void setKeepAliveTimeout(final Duration keepAliveTimeout) {
      this.keepAliveTimeout = keepAliveTimeout;
    }

    @java.lang.SuppressWarnings("all")
    public void setMaxConnectionAge(final Duration maxConnectionAge) {
      this.maxConnectionAge = maxConnectionAge;
    }

    @java.lang.SuppressWarnings("all")
    public void setMaxConnectionAgeGrace(final Duration maxConnectionAgeGrace) {
      this.maxConnectionAgeGrace = maxConnectionAgeGrace;
    }

    @java.lang.SuppressWarnings("all")
    public void setMaxConnectionIdle(final Duration maxConnectionIdle) {
      this.maxConnectionIdle = maxConnectionIdle;
    }

    @java.lang.SuppressWarnings("all")
    public void setPermitKeepAliveTime(final Duration permitKeepAliveTime) {
      this.permitKeepAliveTime = permitKeepAliveTime;
    }

    @java.lang.SuppressWarnings("all")
    public void setMaxInboundMessageSize(final DataSize maxInboundMessageSize) {
      this.maxInboundMessageSize = maxInboundMessageSize;
    }

    @java.lang.SuppressWarnings("all")
    public void setMaxInboundMetadataSize(final DataSize maxInboundMetadataSize) {
      this.maxInboundMetadataSize = maxInboundMetadataSize;
    }

    @java.lang.SuppressWarnings("all")
    public void setPermitKeepAliveWithoutCalls(final Boolean permitKeepAliveWithoutCalls) {
      this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
    }

    /**
     * grpc listen address.
     *
     * <p>If configured, takes precedence over {@code grpc.port} property value. Supported format:
     *
     * <ul>
     *   <li>{@code host:port} (if port is less than 1, uses random value)
     *   <li>{@code host:} (uses default grpc port, 6565 )
     * </ul>
     */
    @java.lang.SuppressWarnings("all")
    public void setPrimaryListenAddress(final InetSocketAddress primaryListenAddress) {
      this.primaryListenAddress = primaryListenAddress;
    }

    @java.lang.SuppressWarnings("all")
    public void setAdditionalListenAddresses(
        final List<InetSocketAddress> additionalListenAddresses) {
      this.additionalListenAddresses = additionalListenAddresses;
    }
  }

  @PostConstruct
  public void init() {
    Optional.ofNullable(nettyServer)
        .map(NettyServerProperties::getPrimaryListenAddress)
        .ifPresent(a -> port = a.getPort());
  }

  /** gRPC server port */
  @java.lang.SuppressWarnings("all")
  public Integer getPort() {
    return this.port;
  }

  @java.lang.SuppressWarnings("all")
  public SecurityProperties getSecurity() {
    return this.security;
  }

  @java.lang.SuppressWarnings("all")
  public RecoveryProperties getRecovery() {
    return this.recovery;
  }

  @java.lang.SuppressWarnings("all")
  public NettyServerProperties getNettyServer() {
    return this.nettyServer;
  }

  @java.lang.SuppressWarnings("all")
  public int getStartUpPhase() {
    return this.startUpPhase;
  }

  /** Enables the embedded grpc server. */
  @java.lang.SuppressWarnings("all")
  public boolean isEnabled() {
    return this.enabled;
  }

  /**
   * In process server name. If the value is not empty, the embedded in-process server will be
   * created and started.
   */
  @java.lang.SuppressWarnings("all")
  public String getInProcessServerName() {
    return this.inProcessServerName;
  }

  /**
   * Enables server reflection using <a
   * href="https://github.com/grpc/grpc-java/blob/master/documentation/server-reflection-tutorial.md">ProtoReflectionService</a>.
   * Available only from gRPC 1.3 or higher.
   */
  @java.lang.SuppressWarnings("all")
  public boolean isEnableReflection() {
    return this.enableReflection;
  }

  /**
   * Number of seconds to wait for preexisting calls to finish before shutting down. A negative
   * value is equivalent to an infinite grace period
   */
  @java.lang.SuppressWarnings("all")
  public int getShutdownGrace() {
    return this.shutdownGrace;
  }

  /** gRPC server port */
  @java.lang.SuppressWarnings("all")
  public void setPort(final Integer port) {
    this.port = port;
  }

  @java.lang.SuppressWarnings("all")
  public void setSecurity(final SecurityProperties security) {
    this.security = security;
  }

  @java.lang.SuppressWarnings("all")
  public void setRecovery(final RecoveryProperties recovery) {
    this.recovery = recovery;
  }

  @java.lang.SuppressWarnings("all")
  public void setNettyServer(final NettyServerProperties nettyServer) {
    this.nettyServer = nettyServer;
  }

  @java.lang.SuppressWarnings("all")
  public void setStartUpPhase(final int startUpPhase) {
    this.startUpPhase = startUpPhase;
  }

  /** Enables the embedded grpc server. */
  @java.lang.SuppressWarnings("all")
  public void setEnabled(final boolean enabled) {
    this.enabled = enabled;
  }

  /**
   * In process server name. If the value is not empty, the embedded in-process server will be
   * created and started.
   */
  @java.lang.SuppressWarnings("all")
  public void setInProcessServerName(final String inProcessServerName) {
    this.inProcessServerName = inProcessServerName;
  }

  /**
   * Enables server reflection using <a
   * href="https://github.com/grpc/grpc-java/blob/master/documentation/server-reflection-tutorial.md">ProtoReflectionService</a>.
   * Available only from gRPC 1.3 or higher.
   */
  @java.lang.SuppressWarnings("all")
  public void setEnableReflection(final boolean enableReflection) {
    this.enableReflection = enableReflection;
  }

  /**
   * Number of seconds to wait for preexisting calls to finish before shutting down. A negative
   * value is equivalent to an infinite grace period
   */
  @java.lang.SuppressWarnings("all")
  public void setShutdownGrace(final int shutdownGrace) {
    this.shutdownGrace = shutdownGrace;
  }
}
