/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.validation;

import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import java.util.Optional;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.lognet.springboot.grpc.FailureHandlingServerInterceptor;
import org.lognet.springboot.grpc.GRpcErrorHandler;
import org.lognet.springboot.grpc.validation.group.RequestMessage;
import org.lognet.springboot.grpc.validation.group.ResponseMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

public class ValidatingInterceptor
implements FailureHandlingServerInterceptor,
Ordered {
    private Validator validator;
    private Integer order;
    private GRpcErrorHandler errorHandler;

    public ValidatingInterceptor(Validator validator) {
        this.validator = validator;
    }

    @Autowired
    public void setErrorHandler(Optional<GRpcErrorHandler> errorHandler) {
        this.errorHandler = errorHandler.orElseGet(() -> new GRpcErrorHandler(){});
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ServerCall.Listener listener = next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void sendMessage(RespT message) {
                Set violations = ValidatingInterceptor.this.validator.validate(message, new Class[]{ResponseMessage.class});
                if (!violations.isEmpty()) {
                    throw ValidatingInterceptor.this.closeCall(message, ValidatingInterceptor.this.errorHandler, this.delegate(), headers, Status.FAILED_PRECONDITION, (Exception)new ConstraintViolationException(violations));
                }
                super.sendMessage(message);
            }
        }, headers);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listener){

            public void onMessage(ReqT message) {
                Set violations = ValidatingInterceptor.this.validator.validate(message, new Class[]{RequestMessage.class});
                if (!violations.isEmpty()) {
                    throw ValidatingInterceptor.this.closeCall(message, ValidatingInterceptor.this.errorHandler, call, headers, Status.INVALID_ARGUMENT, (Exception)new ConstraintViolationException(violations));
                }
                super.onMessage(message);
            }
        };
    }

    public int getOrder() {
        return Optional.ofNullable(this.order).orElse(-2147483638);
    }

    public ValidatingInterceptor order(Integer order) {
        this.order = order;
        return this;
    }
}

