/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.MethodDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityMetadataSource;

public class GrpcSecurityMetadataSource
implements SecurityMetadataSource {
    private Map<MethodDescriptor<?, ?>, List<ConfigAttribute>> methodsMap;

    public GrpcSecurityMetadataSource(Map<MethodDescriptor<?, ?>, List<ConfigAttribute>> methodsMap) {
        this.methodsMap = methodsMap;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        return this.methodsMap.get(object);
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return this.methodsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean supports(Class<?> clazz) {
        return MethodDescriptor.class.isAssignableFrom(clazz);
    }
}

