/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure.metrics;

import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.autoconfigure.metrics.GRpcMetricsProperties;
import org.lognet.springboot.grpc.autoconfigure.metrics.GRpcMetricsTagsContributor;
import org.lognet.springboot.grpc.autoconfigure.metrics.RequestAwareGRpcMetricsTagsContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.Ordered;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class})
@Conditional(value={OnGrpcAndMeterRegistryEnabledCondition.class})
@EnableConfigurationProperties(value={GRpcMetricsProperties.class})
public class GRpcMetricsAutoConfiguration {
    @Bean
    @GRpcGlobalInterceptor
    public ServerInterceptor measure(MeterRegistry registry, GRpcMetricsProperties metricsProperties) {
        return new MonitoringServerInterceptor(registry).order(metricsProperties.getInterceptorOrder());
    }

    @Bean
    public GRpcMetricsTagsContributor defaultTagsContributor(GRpcServerProperties properties) {
        Boolean hasMultipleAddresses = Optional.ofNullable(properties.getNettyServer()).map(GRpcServerProperties.NettyServerProperties::getAdditionalListenAddresses).map(l -> !l.isEmpty()).orElse(false);
        return (status, methodDescriptor, attributes) -> {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(Tag.of((String)"result", (String)status.getCode().name()));
            tags.add(Tag.of((String)"method", (String)methodDescriptor.getFullMethodName()));
            if (hasMultipleAddresses.booleanValue()) {
                Optional.ofNullable(attributes).map(a -> (SocketAddress)a.get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR)).map(Object::toString).map(a -> Tag.of((String)"address", (String)a)).ifPresent(tags::add);
            }
            return tags;
        };
    }

    static class MonitoringServerInterceptor
    implements ServerInterceptor,
    Ordered {
        private static final Logger log = LoggerFactory.getLogger(MonitoringServerInterceptor.class);
        private MeterRegistry registry;
        private Collection<GRpcMetricsTagsContributor> tagsContributors;
        private Integer order;

        @Autowired
        public void setTagsContributors(Collection<GRpcMetricsTagsContributor> tagsContributors) {
            this.tagsContributors = tagsContributors;
        }

        public MonitoringServerInterceptor(MeterRegistry registry) {
            this.registry = registry;
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            final MonitoringServerCall<ReqT, RespT> monitoringServerCall = new MonitoringServerCall<ReqT, RespT>(call, this.registry, this.tagsContributors);
            ServerCall.Listener measuredCall = next.startCall(monitoringServerCall, headers);
            if (call.getMethodDescriptor().getType().clientSendsOneMessage()) {
                return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(measuredCall){

                    public void onMessage(ReqT message) {
                        Stream fd = tagsContributors.stream().filter(RequestAwareGRpcMetricsTagsContributor.class::isInstance).map(RequestAwareGRpcMetricsTagsContributor.class::cast).filter(c -> c.accepts(message)).flatMap(c -> {
                            try {
                                return StreamSupport.stream(c.getTags(message, monitoringServerCall.getMethodDescriptor(), monitoringServerCall.getAttributes()).spliterator(), false);
                            }
                            catch (Throwable t) {
                                log.error("Failed to  execute tag contributor", t);
                                return Stream.empty();
                            }
                        });
                        monitoringServerCall.addTags(fd.collect(Collectors.toList()));
                        super.onMessage(message);
                    }
                };
            }
            return measuredCall;
        }

        public int getOrder() {
            return Optional.ofNullable(this.order).orElse(-2147483628);
        }

        public MonitoringServerInterceptor order(Integer order) {
            this.order = order;
            return this;
        }
    }

    static class MonitoringServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        private MeterRegistry registry;
        final Timer.Sample start;
        private Collection<GRpcMetricsTagsContributor> tagsContributors;
        private List<Tag> additionalTags;
        private AtomicBoolean closed = new AtomicBoolean(false);

        protected MonitoringServerCall(ServerCall<ReqT, RespT> delegate, MeterRegistry registry, Collection<GRpcMetricsTagsContributor> tagsContributors) {
            super(delegate);
            this.start = Timer.start((MeterRegistry)registry);
            this.registry = registry;
            this.tagsContributors = tagsContributors;
        }

        public void close(Status status, Metadata trailers) {
            if (this.closed.compareAndSet(false, true)) {
                Timer.Builder timerBuilder = Timer.builder((String)"grpc.server.calls");
                this.tagsContributors.forEach(c -> timerBuilder.tags(c.getTags(status, this.getMethodDescriptor(), this.getAttributes())));
                Optional.ofNullable(this.additionalTags).ifPresent(arg_0 -> ((Timer.Builder)timerBuilder).tags(arg_0));
                this.start.stop(timerBuilder.register(this.registry));
            }
            super.close(status, trailers);
        }

        public void addTags(List<Tag> tags) {
            this.additionalTags = tags;
        }
    }

    protected static class OnGrpcAndMeterRegistryEnabledCondition
    extends AllNestedConditions {
        OnGrpcAndMeterRegistryEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(annotation={GRpcService.class})
        static class GrpcServiceCondition {
            GrpcServiceCondition() {
            }
        }

        @ConditionalOnBean(value={MeterRegistry.class})
        static class MeterRegistryCondition {
            MeterRegistryCondition() {
            }
        }
    }
}

