/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure.consul;

import com.ecwid.consul.v1.agent.model.NewService;
import java.util.Objects;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.autoconfigure.consul.GRpcConsulHealthCheck;
import org.lognet.springboot.grpc.context.GRpcServerInitializedEvent;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;

public class GrpcConsulRegistrar
implements SmartLifecycle {
    private final ConsulServiceRegistry consulServiceRegistry;
    private ConsulRegistration registration;

    public GrpcConsulRegistrar(ConsulServiceRegistry consulServiceRegistry) {
        this.consulServiceRegistry = consulServiceRegistry;
    }

    @EventListener
    public void onGrpcServerStarted(GRpcServerInitializedEvent initializedEvent) {
        this.registration = this.getRegistration(initializedEvent);
        this.consulServiceRegistry.register(this.registration);
    }

    private ConsulRegistration getRegistration(GRpcServerInitializedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        ConsulDiscoveryProperties consulProperties = (ConsulDiscoveryProperties)applicationContext.getBean(ConsulDiscoveryProperties.class);
        GRpcServerProperties gRpcServerProperties = (GRpcServerProperties)event.getApplicationContext().getBean(GRpcServerProperties.class);
        NewService grpcService = new NewService();
        grpcService.setPort(Integer.valueOf(event.getServer().getPort()));
        if (!consulProperties.isPreferAgentAddress()) {
            grpcService.setAddress(consulProperties.getHostname());
        }
        String appName = "grpc-" + ConsulAutoRegistration.getAppName((ConsulDiscoveryProperties)consulProperties, (Environment)applicationContext.getEnvironment());
        grpcService.setName(ConsulAutoRegistration.normalizeForDns((String)appName));
        grpcService.setId("grpc-" + ConsulAutoRegistration.getInstanceId((ConsulDiscoveryProperties)consulProperties, (ApplicationContext)applicationContext));
        grpcService.setTags(consulProperties.getTags());
        if (consulProperties.isRegisterHealthCheck()) {
            GRpcConsulHealthCheck health = GRpcConsulHealthCheck.builder().socketAddr(consulProperties.getHostname() + ":" + event.getServer().getPort()).grpcUseTlc(Objects.nonNull(gRpcServerProperties.getSecurity())).interval(consulProperties.getHealthCheckInterval()).timeout(consulProperties.getHealthCheckTimeout()).build();
            health.setDeregisterCriticalServiceAfter(consulProperties.getHealthCheckCriticalTimeout());
            grpcService.setCheck((NewService.Check)health);
        }
        return new ConsulRegistration(grpcService, consulProperties);
    }

    public boolean isAutoStartup() {
        return false;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
    }

    public synchronized void stop() {
        this.consulServiceRegistry.deregister(this.registration);
        this.consulServiceRegistry.close();
        this.registration = null;
    }

    public synchronized boolean isRunning() {
        return null != this.registration;
    }

    public int getPhase() {
        return 0;
    }
}

