/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.services.HealthStatusManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.context.GRpcServerInitializedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class GRpcServerRunner
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(GRpcServerRunner.class);
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    @Autowired
    private HealthStatusManager healthStatusManager;
    @Autowired
    private AbstractApplicationContext applicationContext;
    @Autowired
    private GRpcServerProperties gRpcServerProperties;
    private final Consumer<ServerBuilder<?>> configurator;
    private Server server;
    private final ServerBuilder<?> serverBuilder;
    private CountDownLatch latch;

    public GRpcServerRunner(Consumer<ServerBuilder<?>> configurator, ServerBuilder<?> serverBuilder) {
        this.configurator = configurator;
        this.serverBuilder = serverBuilder;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        log.info("Starting gRPC Server ...");
        this.latch = new CountDownLatch(1);
        try {
            Collection globalInterceptors = this.getBeanNamesByTypeWithAnnotation(GRpcGlobalInterceptor.class, ServerInterceptor.class).map(name -> (ServerInterceptor)this.applicationContext.getBeanFactory().getBean(name, ServerInterceptor.class)).collect(Collectors.toList());
            this.serverBuilder.addService(this.healthStatusManager.getHealthService());
            this.getBeanNamesByTypeWithAnnotation(GRpcService.class, BindableService.class).forEach(name -> {
                BindableService srv = (BindableService)this.applicationContext.getBeanFactory().getBean(name, BindableService.class);
                ServerServiceDefinition serviceDefinition = srv.bindService();
                GRpcService gRpcServiceAnn = (GRpcService)this.applicationContext.findAnnotationOnBean(name, GRpcService.class);
                serviceDefinition = this.bindInterceptors(serviceDefinition, gRpcServiceAnn, globalInterceptors);
                this.serverBuilder.addService(serviceDefinition);
                String serviceName = serviceDefinition.getServiceDescriptor().getName();
                this.healthStatusManager.setStatus(serviceName, HealthCheckResponse.ServingStatus.SERVING);
                log.info("'{}' service has been registered.", (Object)srv.getClass().getName());
            });
            if (this.gRpcServerProperties.isEnableReflection()) {
                this.serverBuilder.addService(ProtoReflectionService.newInstance());
                log.info("'{}' service has been registered.", (Object)ProtoReflectionService.class.getName());
            }
            this.configurator.accept(this.serverBuilder);
            this.server = this.serverBuilder.build().start();
            this.applicationContext.publishEvent((ApplicationEvent)new GRpcServerInitializedEvent((ApplicationContext)this.applicationContext, this.server));
            log.info("gRPC Server started, listening on port {}.", (Object)this.server.getPort());
            this.startDaemonAwaitThread();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start GRPC server", e);
        }
    }

    private ServerServiceDefinition bindInterceptors(ServerServiceDefinition serviceDefinition, GRpcService gRpcService, Collection<ServerInterceptor> globalInterceptors) {
        Stream<ServerInterceptor> privateInterceptors = Stream.of(gRpcService.interceptors()).map(interceptorClass -> {
            try {
                return 0 < this.applicationContext.getBeanNamesForType(interceptorClass).length ? (ServerInterceptor)this.applicationContext.getBean(interceptorClass) : (ServerInterceptor)interceptorClass.newInstance();
            }
            catch (Exception e) {
                throw new BeanCreationException("Failed to create interceptor instance.", (Throwable)e);
            }
        });
        List interceptors = Stream.concat(gRpcService.applyGlobalInterceptors() ? globalInterceptors.stream() : Stream.empty(), privateInterceptors).distinct().sorted(this.serverInterceptorOrderComparator()).collect(Collectors.toList());
        return ServerInterceptors.intercept((ServerServiceDefinition)serviceDefinition, interceptors);
    }

    private Comparator<Object> serverInterceptorOrderComparator() {
        return new AnnotationAwareOrderComparator().withSourceProvider(o -> {
            ArrayList sources = new ArrayList(2);
            Optional<RootBeanDefinition> rootBeanDefinition = Stream.of(this.applicationContext.getBeanNamesForType(o.getClass())).findFirst().map(name -> this.applicationContext.getBeanFactory().getBeanDefinition(name)).filter(RootBeanDefinition.class::isInstance).map(RootBeanDefinition.class::cast);
            rootBeanDefinition.map(RootBeanDefinition::getResolvedFactoryMethod).ifPresent(sources::add);
            rootBeanDefinition.map(RootBeanDefinition::getTargetType).filter(t -> t != o.getClass()).ifPresent(sources::add);
            return sources.toArray();
        }).reversed();
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread(() -> {
            try {
                this.isRunning.set(true);
                this.latch.await();
            }
            catch (InterruptedException e) {
                log.error("gRPC server awaiter interrupted.", (Throwable)e);
            }
            finally {
                this.isRunning.set(false);
            }
        });
        awaitThread.setName("grpc-server-awaiter");
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    public void stop() {
        Optional.ofNullable(this.server).ifPresent(s -> {
            log.info("Shutting down gRPC server ...");
            s.getServices().forEach(def -> this.healthStatusManager.clearStatus(def.getServiceDescriptor().getName()));
            s.shutdown();
            int shutdownGrace = this.gRpcServerProperties.getShutdownGrace();
            try {
                if (shutdownGrace < 0) {
                    s.awaitTermination();
                } else if (shutdownGrace > 0) {
                    s.awaitTermination((long)shutdownGrace, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                log.error("gRPC server interrupted during destroy.", (Throwable)e);
            }
            finally {
                this.latch.countDown();
            }
            log.info("gRPC server stopped.");
        });
    }

    private <T> Stream<String> getBeanNamesByTypeWithAnnotation(Class<? extends Annotation> annotationType, Class<T> beanType) throws Exception {
        return Stream.of(this.applicationContext.getBeanNamesForType(beanType)).filter(name -> {
            BeanDefinition beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(name);
            Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(annotationType);
            if (beansWithAnnotation.containsKey(name)) {
                return true;
            }
            if (beanDefinition.getSource() instanceof AnnotatedTypeMetadata) {
                return ((AnnotatedTypeMetadata)AnnotatedTypeMetadata.class.cast(beanDefinition.getSource())).isAnnotated(annotationType.getName());
            }
            return false;
        });
    }

    public int getPhase() {
        return this.gRpcServerProperties.getStartUpPhase();
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }
}

