// Generated by delombok at Wed Jun 02 06:28:58 UTC 2021
package org.lognet.springboot.grpc.security;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.lognet.springboot.grpc.FailureHandlingServerInterceptor;
import org.lognet.springboot.grpc.GRpcErrorHandler;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityInterceptor extends AbstractSecurityInterceptor
    implements FailureHandlingServerInterceptor, Ordered {
  @java.lang.SuppressWarnings("all")
  private static final org.slf4j.Logger log =
      org.slf4j.LoggerFactory.getLogger(SecurityInterceptor.class);

  private final GrpcSecurityMetadataSource securedMethods;
  private final AuthenticationSchemeSelector schemeSelector;
  private GRpcServerProperties.SecurityProperties.Auth authCfg;
  private GRpcErrorHandler errorHandler;

  public SecurityInterceptor(
      GrpcSecurityMetadataSource securedMethods, AuthenticationSchemeSelector schemeSelector) {
    this.securedMethods = securedMethods;
    this.schemeSelector = schemeSelector;
  }

  @Autowired
  public void setErrorHandler(Optional<GRpcErrorHandler> errorHandler) {
    this.errorHandler = errorHandler.orElseGet(() -> new GRpcErrorHandler() {});
  }

  public void setConfig(GRpcServerProperties.SecurityProperties.Auth authCfg) {
    this.authCfg =
        Optional.ofNullable(authCfg).orElseGet(GRpcServerProperties.SecurityProperties.Auth::new);
  }

  @Override
  public int getOrder() {
    return Optional.ofNullable(authCfg.getInterceptorOrder()).orElse(Ordered.HIGHEST_PRECEDENCE);
  }

  @Override
  public Class<?> getSecureObjectClass() {
    return MethodDescriptor.class;
  }

  @Override
  public GrpcSecurityMetadataSource obtainSecurityMetadataSource() {
    return securedMethods;
  }

  @Override
  public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(
      ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
    final CharSequence authorization =
        Optional.ofNullable(
                headers.get(
                    Metadata.Key.of(
                        "Authorization" + Metadata.BINARY_HEADER_SUFFIX,
                        Metadata.BINARY_BYTE_MARSHALLER)))
            .map(auth -> (CharSequence) StandardCharsets.UTF_8.decode(ByteBuffer.wrap(auth)))
            .orElse(
                headers.get(Metadata.Key.of("Authorization", Metadata.ASCII_STRING_MARSHALLER)));
    final Authentication authentication =
        null == authorization
            ? null
            : schemeSelector
                .getAuthScheme(authorization)
                .orElseThrow(
                    () ->
                        new RuntimeException(
                            "Can\'t get authentication from authorization header"));
    try {
      SecurityContext context = SecurityContextHolder.createEmptyContext();
      context.setAuthentication(authentication);
      SecurityContextHolder.setContext(context);
      beforeInvocation(call.getMethodDescriptor());
      Context ctx =
          Context.current()
              .withValue(
                  GrpcSecurity.AUTHENTICATION_CONTEXT_KEY,
                  SecurityContextHolder.getContext().getAuthentication());
      return Contexts.interceptCall(ctx, call, headers, next);
    } catch (AccessDeniedException e) {
      return fail(next, call, headers, Status.PERMISSION_DENIED, e);
    } catch (Exception e) {
      return fail(next, call, headers, Status.UNAUTHENTICATED, e);
    } finally {
      SecurityContextHolder.getContext().setAuthentication(null);
    }
  }

  private <RespT, ReqT> ServerCall.Listener<ReqT> fail(
      ServerCallHandler<ReqT, RespT> next,
      ServerCall<ReqT, RespT> call,
      Metadata headers,
      final Status status,
      Exception exception) {
    if (authCfg.isFailFast()) {
      throw closeCall(null, errorHandler, call, headers, status, exception);
    } else {
      return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(
          next.startCall(call, headers)) {
        @Override
        public void onMessage(ReqT message) {
          throw closeCall(message, errorHandler, call, headers, status, exception);
        }
      };
    }
  }
}
