/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.springdata.util.Expressions;
import org.thymeleaf.dialect.springdata.util.PageUtils;
import org.thymeleaf.dialect.springdata.util.Strings;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

final class PaginationSortAttrProcessor
extends AbstractAttributeTagProcessor {
    private static final String ATTR_NAME = "pagination-sort";
    public static final int PRECEDENCE = 1000;

    public PaginationSortAttrProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, null, false, ATTR_NAME, true, 1000, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        String attrValue = String.valueOf(Expressions.evaluate((IExpressionContext)context, attributeValue)).trim();
        Page<?> page = PageUtils.findPage(context);
        String url = PageUtils.createSortUrl(context, attrValue);
        Sort sort = page.getSort();
        boolean isSorted = sort != null && sort.getOrderFor(attributeValue) != null;
        String clas = isSorted ? "sorted-".concat(sort.getOrderFor(attributeValue).getDirection().toString().toLowerCase()) : "";
        structureHandler.setAttribute("href", url);
        String currentClass = tag.getAttributeValue("class");
        structureHandler.setAttribute("class", Strings.concat(currentClass, " ", clas));
    }
}

