/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamsesso.jsonlogic.evaluator.expressions;

import io.github.jamsesso.jsonlogic.ast.JsonLogicArray;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluationException;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluator;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicExpression;
import io.github.jamsesso.jsonlogic.utils.ArrayLike;
import java.util.ArrayList;
import java.util.Collections;

public class MapExpression
implements JsonLogicExpression {
    public static final MapExpression INSTANCE = new MapExpression();

    private MapExpression() {
    }

    @Override
    public String key() {
        return "map";
    }

    @Override
    public Object evaluate(JsonLogicEvaluator evaluator, JsonLogicArray arguments, Object data) throws JsonLogicEvaluationException {
        if (arguments.size() != 2) {
            throw new JsonLogicEvaluationException("map expects exactly 2 arguments");
        }
        Object maybeArray = evaluator.evaluate(arguments.get(0), data);
        if (!ArrayLike.isEligible(maybeArray)) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : new ArrayLike(maybeArray)) {
            result.add(evaluator.evaluate(arguments.get(1), item));
        }
        return result;
    }
}

