/*
 * Decompiled with CFR 0.152.
 */
package io.github.honeycombcheesecake.play.silhouette.impl.providers.oauth1.secrets;

import io.github.honeycombcheesecake.play.silhouette.api.crypto.Crypter;
import io.github.honeycombcheesecake.play.silhouette.api.crypto.Signer;
import io.github.honeycombcheesecake.play.silhouette.impl.exceptions.OAuth1TokenSecretException;
import io.github.honeycombcheesecake.play.silhouette.impl.exceptions.OAuth1TokenSecretException$;
import io.github.honeycombcheesecake.play.silhouette.impl.providers.oauth1.secrets.CookieSecret;
import io.github.honeycombcheesecake.play.silhouette.impl.providers.oauth1.secrets.CookieSecretProvider$;
import java.io.Serializable;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.Format$;
import play.api.libs.json.JodaReads$;
import play.api.libs.json.JodaWrites$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonConfiguration$;
import play.api.libs.json.OFormat;
import play.api.libs.json.OFormat$;
import play.api.libs.json.OWrites$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CookieSecret$
implements Serializable {
    public static final CookieSecret$ MODULE$ = new CookieSecret$();
    private static final OFormat<CookieSecret> jsonFormat;

    static {
        OFormat underlying = (OFormat)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("value")).format(Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.StringReads(), (Writes)Writes$.MODULE$.StringWrites())), OFormat$.MODULE$.functionalCanBuildFormats(FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult())), OWrites$.MODULE$.functionalCanBuildOWrites())).and((Object)JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("expirationDate")).format(Format$.MODULE$.GenericFormat(JodaReads$.MODULE$.DefaultJodaDateTimeReads(), (Writes)JodaWrites$.MODULE$.JodaDateTimeWrites()))).apply((Function2 & Serializable)(value, expirationDate) -> new CookieSecret((String)value, (DateTime)expirationDate), package$.MODULE$.unlift((Function1 & Serializable)x$0 -> MODULE$.unapply((CookieSecret)x$0)), OFormat$.MODULE$.invariantFunctorOFormat());
        Function1 & Serializable rfn = (Function1 & Serializable)x0$1 -> {
            JsError jsError;
            JsValue jsValue = x0$1;
            if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                jsError = underlying.reads((JsValue)jsObject);
            } else {
                jsError = JsError$.MODULE$.apply("error.expected.jsobject");
            }
            return jsError;
        };
        jsonFormat = OFormat$.MODULE$.apply((Function1)rfn, (Function1 & Serializable)o -> underlying.writes(o));
    }

    public OFormat<CookieSecret> jsonFormat() {
        return jsonFormat;
    }

    public String serialize(CookieSecret secret, Signer signer, Crypter crypter) {
        return signer.sign(crypter.encrypt(Json$.MODULE$.toJson((Object)secret, this.jsonFormat()).toString()));
    }

    public Try<CookieSecret> unserialize(String str, Signer signer, Crypter crypter) {
        Failure failure;
        Try<String> try_ = signer.extract(str);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String data = (String)success.value();
            failure = this.buildSecret(crypter.decrypt(data));
        } else if (try_ instanceof Failure) {
            Failure failure2 = (Failure)try_;
            Throwable e = failure2.exception();
            failure = new Failure((Throwable)new OAuth1TokenSecretException(CookieSecretProvider$.MODULE$.InvalidCookieSignature(), (Option<Throwable>)new Some((Object)e)));
        } else {
            throw new MatchError(try_);
        }
        return failure;
    }

    private Try<CookieSecret> buildSecret(String str) {
        Success success;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Json$.MODULE$.parse(str));
        if (try_ instanceof Success) {
            Success success2;
            Success success3 = (Success)try_;
            JsValue json = (JsValue)success3.value();
            Either either = json.validate(this.jsonFormat()).asEither();
            if (either instanceof Left) {
                Left left = (Left)either;
                Seq error = (Seq)left.value();
                success2 = new Failure((Throwable)new OAuth1TokenSecretException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieSecretProvider$.MODULE$.InvalidSecretFormat()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{error})), OAuth1TokenSecretException$.MODULE$.$lessinit$greater$default$2()));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                CookieSecret authenticator = (CookieSecret)right.value();
                success2 = new Success((Object)authenticator);
            } else {
                throw new MatchError((Object)either);
            }
            success = success2;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            success = new Failure((Throwable)new OAuth1TokenSecretException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieSecretProvider$.MODULE$.InvalidJson()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{str})), (Option<Throwable>)new Some((Object)error)));
        } else {
            throw new MatchError((Object)try_);
        }
        return success;
    }

    public CookieSecret apply(String value, DateTime expirationDate) {
        return new CookieSecret(value, expirationDate);
    }

    public Option<Tuple2<String, DateTime>> unapply(CookieSecret x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.value(), (Object)x$0.expirationDate()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CookieSecret$.class);
    }

    private CookieSecret$() {
    }
}

