/*
 * Decompiled with CFR 0.152.
 */
package io.github.honeycombcheesecake.play.silhouette.impl.providers;

import io.github.honeycombcheesecake.play.silhouette.api.LoginInfo;
import io.github.honeycombcheesecake.play.silhouette.api.exceptions.ConfigurationException;
import io.github.honeycombcheesecake.play.silhouette.api.exceptions.ConfigurationException$;
import io.github.honeycombcheesecake.play.silhouette.api.repositories.AuthInfoRepository;
import io.github.honeycombcheesecake.play.silhouette.api.util.Credentials;
import io.github.honeycombcheesecake.play.silhouette.api.util.PasswordHasherRegistry;
import io.github.honeycombcheesecake.play.silhouette.impl.exceptions.IdentityNotFoundException;
import io.github.honeycombcheesecake.play.silhouette.impl.exceptions.IdentityNotFoundException$;
import io.github.honeycombcheesecake.play.silhouette.impl.exceptions.InvalidPasswordException;
import io.github.honeycombcheesecake.play.silhouette.impl.exceptions.InvalidPasswordException$;
import io.github.honeycombcheesecake.play.silhouette.impl.providers.CredentialsProvider$;
import io.github.honeycombcheesecake.play.silhouette.impl.providers.PasswordProvider;
import io.github.honeycombcheesecake.play.silhouette.impl.providers.PasswordProvider$Authenticated$;
import io.github.honeycombcheesecake.play.silhouette.impl.providers.PasswordProvider$InvalidPassword$;
import io.github.honeycombcheesecake.play.silhouette.impl.providers.PasswordProvider$NotFound$;
import io.github.honeycombcheesecake.play.silhouette.impl.providers.PasswordProvider$UnsupportedHasher$;
import java.io.Serializable;
import javax.inject.Inject;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e4A\u0001E\t\u0001A!A1\u0006\u0001BC\u0002\u0013EA\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u0003.\u0011!1\u0004A!b\u0001\n#9\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011}\u0002!Q1A\u0005\u0004\u0001C\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u00061\u0002!\t%\u0017\u0005\u0006E\u0002!\ta\u0019\u0005\u0006a\u0002!\t!]\u0004\u0006gFA\t\u0001\u001e\u0004\u0006!EA\t!\u001e\u0005\u0006\u00112!\tA\u001e\u0005\bo2\u0011\r\u0011\"\u0001Z\u0011\u0019AH\u0002)A\u00055\n\u00192I]3eK:$\u0018.\u00197t!J|g/\u001b3fe*\u0011!cE\u0001\naJ|g/\u001b3feNT!\u0001F\u000b\u0002\t%l\u0007\u000f\u001c\u0006\u0003-]\t!b]5mQ>,X\r\u001e;f\u0015\tA\u0012$\u0001\u0003qY\u0006L(B\u0001\u000e\u001c\u0003MAwN\\3zG>l'm\u00195fKN,7-Y6f\u0015\taR$\u0001\u0004hSRDWO\u0019\u0006\u0002=\u0005\u0011\u0011n\\\u0002\u0001'\r\u0001\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!JS\"A\t\n\u0005)\n\"\u0001\u0005)bgN<xN\u001d3Qe>4\u0018\u000eZ3s\u0003I\tW\u000f\u001e5J]\u001a|'+\u001a9pg&$xN]=\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u0019I,\u0007o\\:ji>\u0014\u0018.Z:\u000b\u0005I*\u0012aA1qS&\u0011Ag\f\u0002\u0013\u0003V$\b.\u00138g_J+\u0007o\\:ji>\u0014\u00180A\nbkRD\u0017J\u001c4p%\u0016\u0004xn]5u_JL\b%\u0001\fqCN\u001cxo\u001c:e\u0011\u0006\u001c\b.\u001a:SK\u001eL7\u000f\u001e:z+\u0005A\u0004CA\u001d=\u001b\u0005Q$BA\u001e2\u0003\u0011)H/\u001b7\n\u0005uR$A\u0006)bgN<xN\u001d3ICNDWM\u001d*fO&\u001cHO]=\u0002/A\f7o]<pe\u0012D\u0015m\u001d5feJ+w-[:uef\u0004\u0013\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#$\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\r\u000e\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002#\u0015DXmY;uS>t7i\u001c8uKb$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u00156sECA&M!\tA\u0003\u0001C\u0003@\u000f\u0001\u000f\u0011\tC\u0003,\u000f\u0001\u0007Q\u0006C\u00037\u000f\u0001\u0007\u0001\b\u000b\u0002\b!B\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\u0007S:TWm\u0019;\u000b\u0003U\u000bQA[1wCbL!a\u0016*\u0003\r%s'.Z2u\u0003\tIG-F\u0001[!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0003mC:<'\"A0\u0002\t)\fg/Y\u0005\u0003Cr\u0013aa\u0015;sS:<\u0017\u0001D1vi\",g\u000e^5dCR,GC\u00013l!\r\u0011UmZ\u0005\u0003M\u000e\u0013aAR;ukJ,\u0007C\u00015j\u001b\u0005\t\u0014B\u000162\u0005%aunZ5o\u0013:4w\u000eC\u0003m\u0013\u0001\u0007Q.A\u0006de\u0016$WM\u001c;jC2\u001c\bCA\u001do\u0013\ty'HA\u0006De\u0016$WM\u001c;jC2\u001c\u0018!\u00037pO&t\u0017J\u001c4p)\t!'\u000fC\u0003m\u0015\u0001\u0007Q.A\nDe\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'\u000f\u0005\u0002)\u0019M\u0011A\"\t\u000b\u0002i\u0006\u0011\u0011\nR\u0001\u0004\u0013\u0012\u0003\u0003")
public class CredentialsProvider
implements PasswordProvider {
    private final AuthInfoRepository authInfoRepository;
    private final PasswordHasherRegistry passwordHasherRegistry;
    private final ExecutionContext executionContext;
    private volatile PasswordProvider$Authenticated$ Authenticated$module;
    private volatile PasswordProvider$InvalidPassword$ InvalidPassword$module;
    private volatile PasswordProvider$UnsupportedHasher$ UnsupportedHasher$module;
    private volatile PasswordProvider$NotFound$ NotFound$module;

    public static String ID() {
        return CredentialsProvider$.MODULE$.ID();
    }

    @Override
    public Future<PasswordProvider.State> authenticate(LoginInfo loginInfo, String password) {
        return PasswordProvider.authenticate$(this, loginInfo, password);
    }

    @Override
    public PasswordProvider$Authenticated$ Authenticated() {
        if (this.Authenticated$module == null) {
            this.Authenticated$lzycompute$1();
        }
        return this.Authenticated$module;
    }

    @Override
    public PasswordProvider$InvalidPassword$ InvalidPassword() {
        if (this.InvalidPassword$module == null) {
            this.InvalidPassword$lzycompute$1();
        }
        return this.InvalidPassword$module;
    }

    @Override
    public PasswordProvider$UnsupportedHasher$ UnsupportedHasher() {
        if (this.UnsupportedHasher$module == null) {
            this.UnsupportedHasher$lzycompute$1();
        }
        return this.UnsupportedHasher$module;
    }

    @Override
    public PasswordProvider$NotFound$ NotFound() {
        if (this.NotFound$module == null) {
            this.NotFound$lzycompute$1();
        }
        return this.NotFound$module;
    }

    @Override
    public AuthInfoRepository authInfoRepository() {
        return this.authInfoRepository;
    }

    @Override
    public PasswordHasherRegistry passwordHasherRegistry() {
        return this.passwordHasherRegistry;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String id() {
        return CredentialsProvider$.MODULE$.ID();
    }

    public Future<LoginInfo> authenticate(Credentials credentials) {
        return this.loginInfo(credentials).flatMap((Function1 & Serializable)loginInfo -> this.authenticate((LoginInfo)loginInfo, credentials.password()).map((Function1 & Serializable)x0$1 -> {
            PasswordProvider.State state = x0$1;
            if (!this.Authenticated().equals(state)) {
                if (state instanceof PasswordProvider.InvalidPassword) {
                    PasswordProvider.InvalidPassword invalidPassword = (PasswordProvider.InvalidPassword)state;
                    String error = invalidPassword.error();
                    throw new InvalidPasswordException(error, InvalidPasswordException$.MODULE$.$lessinit$greater$default$2());
                }
                if (state instanceof PasswordProvider.UnsupportedHasher) {
                    PasswordProvider.UnsupportedHasher unsupportedHasher = (PasswordProvider.UnsupportedHasher)state;
                    String error = unsupportedHasher.error();
                    throw new ConfigurationException(error, ConfigurationException$.MODULE$.$lessinit$greater$default$2());
                }
                if (state instanceof PasswordProvider.NotFound) {
                    PasswordProvider.NotFound notFound = (PasswordProvider.NotFound)state;
                    String error = notFound.error();
                    throw new IdentityNotFoundException(error, IdentityNotFoundException$.MODULE$.$lessinit$greater$default$2());
                }
                throw new MatchError((Object)state);
            }
            LoginInfo loginInfo = loginInfo;
            return loginInfo;
        }, this.executionContext()), this.executionContext());
    }

    public Future<LoginInfo> loginInfo(Credentials credentials) {
        return Future$.MODULE$.successful((Object)new LoginInfo(this.id(), credentials.identifier()));
    }

    private final void Authenticated$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.Authenticated$module == null) {
                this.Authenticated$module = new PasswordProvider$Authenticated$(this);
            }
        }
    }

    private final void InvalidPassword$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.InvalidPassword$module == null) {
                this.InvalidPassword$module = new PasswordProvider$InvalidPassword$(this);
            }
        }
    }

    private final void UnsupportedHasher$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.UnsupportedHasher$module == null) {
                this.UnsupportedHasher$module = new PasswordProvider$UnsupportedHasher$(this);
            }
        }
    }

    private final void NotFound$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.NotFound$module == null) {
                this.NotFound$module = new PasswordProvider$NotFound$(this);
            }
        }
    }

    @Inject
    public CredentialsProvider(AuthInfoRepository authInfoRepository, PasswordHasherRegistry passwordHasherRegistry, ExecutionContext executionContext) {
        this.authInfoRepository = authInfoRepository;
        this.passwordHasherRegistry = passwordHasherRegistry;
        this.executionContext = executionContext;
        PasswordProvider.$init$(this);
    }
}

