/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sude.logger;

import java.util.logging.Level;
import nl.altindag.sude.Logger;

public final class JavaUtilLoggingLogger
implements Logger {
    private final java.util.logging.Logger logger;

    private JavaUtilLoggingLogger(String name) {
        this.logger = java.util.logging.Logger.getLogger(name);
    }

    public static Logger getLogger(String name) {
        return new JavaUtilLoggingLogger(name);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void trace(String message) {
        this.logger.log(Level.FINEST, message);
    }

    @Override
    public void trace(String message, Throwable throwable) {
        this.logger.log(Level.FINEST, message, throwable);
    }

    @Override
    public void debug(String message) {
        this.logger.log(Level.FINER, message);
    }

    @Override
    public void debug(String message, Throwable throwable) {
        this.logger.log(Level.FINER, message, throwable);
    }

    @Override
    public void info(String message) {
        this.logger.log(Level.INFO, message);
    }

    @Override
    public void info(String message, Throwable throwable) {
        this.logger.log(Level.INFO, message, throwable);
    }

    @Override
    public void warn(String message) {
        this.logger.log(Level.WARNING, message);
    }

    @Override
    public void warn(String message, Throwable throwable) {
        this.logger.log(Level.WARNING, message, throwable);
    }

    @Override
    public void error(String message) {
        this.logger.log(Level.SEVERE, message);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.logger.log(Level.SEVERE, message, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }
}

