/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.socket;

import java.io.IOException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import nl.altindag.ssl.socket.DelegatingSSLServerSocket;
import nl.altindag.ssl.util.internal.Callable;
import nl.altindag.sude.Logger;
import nl.altindag.sude.LoggerFactory;

class FenixSSLServerSocket
extends DelegatingSSLServerSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(FenixSSLServerSocket.class);
    private final SSLParameters sslParameters;

    public FenixSSLServerSocket(SSLServerSocket socket, SSLParameters sslParameters) throws IOException {
        super(socket);
        this.sslParameters = sslParameters;
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        LOGGER.debug("Ignoring provided ssl parameters");
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        LOGGER.debug("Ignoring provided ciphers");
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        LOGGER.debug("Ignoring provided protocols");
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        LOGGER.debug("Ignoring provided indicator for need client auth");
    }

    @Override
    public void setWantClientAuth(boolean want) {
        LOGGER.debug("Ignoring provided indicator for want client auth");
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.updateAndGet(() -> super.getEnabledCipherSuites());
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.updateAndGet(() -> super.getEnabledProtocols());
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.updateAndGet(() -> super.getNeedClientAuth());
    }

    @Override
    public boolean getWantClientAuth() {
        return this.updateAndGet(() -> super.getWantClientAuth());
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.updateAndGet(() -> super.getSSLParameters());
    }

    private <T> T updateAndGet(Callable<T> callable) {
        this.socket.setSSLParameters(this.sslParameters);
        return callable.call();
    }
}

