/*
 * Decompiled with CFR 0.152.
 */
package io.github.green4j.jelly;

import io.github.green4j.jelly.CopyingStringBuilder;
import io.github.green4j.jelly.JsonParserListener;
import io.github.green4j.jelly.JsonStringBuilder;
import io.github.green4j.jelly.MutableJsonNumber;

public final class JsonParser {
    private static final int LEXEMA_TRUE_STARTED_T = 1;
    private static final int LEXEMA_TRUE_STARTED_TR = 2;
    private static final int LEXEMA_TRUE_STARTED_TRU = 3;
    private static final int LEXEMA_FALSE_STARTED_F = 4;
    private static final int LEXEMA_FALSE_STARTED_FA = 5;
    private static final int LEXEMA_FALSE_STARTED_FAL = 6;
    private static final int LEXEMA_FALSE_STARTED_FALS = 7;
    private static final int LEXEMA_NULL_STARTED_N = 8;
    private static final int LEXEMA_NULL_STARTED_NU = 9;
    private static final int LEXEMA_NULL_STARTED_NUL = 10;
    private static final int LEXEMA_STRING_STARTED = 11;
    private static final int LEXEMA_STRING_STARTED_ESCAPE = 12;
    private static final int LEXEMA_STRING_STARTED_ESCAPE_UNICODE = 13;
    private static final int LEXEMA_STRING_STARTED_ESCAPE_UNICODE_1 = 14;
    private static final int LEXEMA_STRING_STARTED_ESCAPE_UNICODE_2 = 15;
    private static final int LEXEMA_STRING_STARTED_ESCAPE_UNICODE_3 = 16;
    private static final int LEXEMA_NUMBER_STARTED_MANTISSA_SIGN = 17;
    private static final int LEXEMA_NUMBER_STARTED_MANTISSA_INTEGER_PART = 18;
    private static final int LEXEMA_NUMBER_STARTED_MANTISSA_FRACTIONAL_PART = 19;
    private static final int LEXEMA_NUMBER_STARTED_E = 20;
    private static final int LEXEMA_NUMBER_STARTED_E_SIGN = 21;
    private static final int LEXEMA_NUMBER_STARTED_E_VALUE = 22;
    private static final int LEXEMA_READY = 23;
    private static final int LEXEMA_CURLY_BRACKET_LEFT_READY = 24;
    private static final int LEXEMA_CURLY_BRACKET_RIGHT_READY = 25;
    private static final int LEXEMA_BOX_BRACKET_LEFT_READY = 26;
    private static final int LEXEMA_BOX_BRACKET_RIGHT_READY = 27;
    private static final int LEXEMA_COMMA_READY = 28;
    private static final int LEXEMA_COLON_READY = 29;
    private static final int LEXEMA_STRING_READY = 30;
    private static final int LEXEMA_NUMBER_READY = 31;
    private static final int LEXEMA_TRUE_READY = 32;
    private static final int LEXEMA_FALSE_READY = 33;
    private static final int LEXEMA_NULL_READY = 34;
    private static final int EXPRESSION_INITIAL = 0;
    private static final int EXPRESSION_OBJECT_STARTED = 1;
    private static final int EXPRESSION_OBJECT_STARTED_MEMBER_NAME = 2;
    private static final int EXPRESSION_OBJECT_STARTED_MEMBER_NAME_VALUE_COLON_DELIMITER = 3;
    private static final int EXPRESSION_OBJECT_STARTED_MEMBER_VALUE = 4;
    private static final int EXPRESSION_OBJECT_STARTED_MEMBER_COMMA_DELIMITER = 5;
    private static final int EXPRESSION_ARRAY_STARTED = 6;
    private static final int EXPRESSION_ARRAY_STARTED_VALUE = 7;
    private static final int EXPRESSION_ARRAY_STARTED_COMMA_DELIMITER = 8;
    private static final String ERROR_INCORRECT_STRING_MESSAGE = "Incorrect string";
    private static final String ERROR_INCORRECT_ESCAPING_MESSAGE = "Incorrect character escaping";
    private static final String ERROR_MESSAGE_INCORRECT_UNICODE_ESCAPING = "Incorrect unicode escaping";
    private static final String ERROR_INCORRECT_NUMBER_MESSAGE = "Incorrect number";
    private static final String ERROR_TRUE_EXPECTED_MESSAGE = "'true' expected";
    private static final String ERROR_FALSE_EXPECTED_MESSAGE = "'false' expected";
    private static final String ERROR_NULL_EXPECTED_MESSAGE = "'null' expected";
    private static final String ERROR_UNEXPECTED_CURLY_BRACKET_LEFT_MESSAGE = "Unexpected '{'";
    private static final String ERROR_UNEXPECTED_CURLY_BRACKET_RIGHT_MESSAGE = "Unexpected '}'";
    private static final String ERROR_UNEXPECTED_BOX_BRACKET_LEFT_MESSAGE = "Unexpected '['";
    private static final String ERROR_UNEXPECTED_BOX_BRACKET_RIGHT_MESSAGE = "Unexpected ']'";
    private static final String ERROR_UNEXPECTED_COMMA_MESSAGE = "Unexpected ','";
    private static final String ERROR_UNEXPECTED_COLON_MESSAGE = "Unexpected ':'";
    private static final String ERROR_UNEXPECTED_STRING_MESSAGE = "Unexpected string";
    private static final String ERROR_UNEXPECTED_NUMBER_MESSAGE = "Unexpected number";
    private static final String ERROR_UNEXPECTED_TRUE_MESSAGE = "Unexpected 'true'";
    private static final String ERROR_UNEXPECTED_FALSE_MESSAGE = "Unexpected 'false'";
    private static final String ERROR_UNEXPECTED_NULL_MESSAGE = "Unexpected 'null'";
    private static final String ERROR_UNEXPECTED_CHAR_MESSAGE = "Unexpected char";
    private static final String ERROR_INTERNAL_UNEXPECTED_LEXEMA_ERROR_MESSAGE = "Internal error. Unexpected lexema";
    private static final int JSON_STARTED_NOTIFICATION_REQUIRED = -1;
    private static final int RESET_REQUIRED = -2;
    private final Next next = () -> this.next();
    private final MutableJsonNumber number = new MutableJsonNumber();
    private final JsonStringBuilder string;
    private JsonParserListener listener;
    private boolean notifyObjectMemberNameString;
    private CharSequence currentData;
    private int currentLen;
    private int currentStart;
    private int currentPos;
    private int currentLexemaState;
    private int currentLexemaPosition;
    private int numberMantissaExp;
    private int numberMinuses;
    private String error;
    private int errorPosition;
    private int[] scopeStack = new int[8];
    private int scopeStackDepth;

    public static void parseNumber(CharSequence data, MutableJsonNumber to) {
        int currentLexState = 23;
        int numberMantissaExp = 0;
        int numberMinuses = 0;
        int len = data.length();
        block39: for (int pos = 0; pos < len; ++pos) {
            char c = data.charAt(pos);
            switch (currentLexState) {
                case 23: {
                    switch (c) {
                        case '-': {
                            to.setMantissa(0L);
                            to.setExp(0);
                            numberMantissaExp = 0;
                            numberMinuses = 2;
                            currentLexState = 17;
                            continue block39;
                        }
                        case '+': {
                            to.setMantissa(0L);
                            to.setExp(0);
                            numberMantissaExp = 0;
                            numberMinuses = 0;
                            currentLexState = 17;
                            continue block39;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            to.setMantissa(c - 48);
                            to.setExp(0);
                            numberMantissaExp = 0;
                            numberMinuses = 0;
                            if (len - pos <= 1) break block39;
                            ++pos;
                            while ((c = data.charAt(pos)) >= '0' && c <= '9') {
                                to.setMantissa(to.mantissa() * 10L + (long)(c - 48));
                                if (++pos != len) continue;
                                break block39;
                            }
                            switch (c) {
                                case '.': {
                                    currentLexState = 19;
                                    continue block39;
                                }
                                case 'E': 
                                case 'e': {
                                    currentLexState = 20;
                                    continue block39;
                                }
                            }
                            throw new IllegalArgumentException("Incorrect number. Unexpected char '" + c + "' at the position " + pos);
                        }
                        default: {
                            throw new IllegalArgumentException("Incorrect number. Unexpected char '" + c + "' at the position " + pos);
                        }
                    }
                }
                case 18: {
                    while (c >= '0' && c <= '9') {
                        to.setMantissa(to.mantissa() * 10L + (long)(c - 48));
                        if (++pos == len) break block39;
                        c = data.charAt(pos);
                    }
                    switch (c) {
                        case '.': {
                            currentLexState = 19;
                            continue block39;
                        }
                        case 'E': 
                        case 'e': {
                            currentLexState = 20;
                            continue block39;
                        }
                    }
                    throw new IllegalArgumentException("Incorrect number. Unexpected char '" + c + "' at the position " + pos);
                }
                case 17: {
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            to.setMantissa(to.mantissa() * 10L + (long)(c - 48));
                            currentLexState = 18;
                            continue block39;
                        }
                    }
                    throw new IllegalArgumentException("Incorrect number. Unexpected char '" + c + "' at the position " + pos);
                }
                case 19: {
                    while (c >= '0' && c <= '9') {
                        to.setMantissa(to.mantissa() * 10L + (long)(c - 48));
                        --numberMantissaExp;
                        if (++pos == len) break block39;
                        c = data.charAt(pos);
                    }
                    switch (c) {
                        case 'E': 
                        case 'e': {
                            currentLexState = 20;
                            continue block39;
                        }
                    }
                    throw new IllegalArgumentException("Incorrect number. Unexpected char '" + c + "' at the position " + pos);
                }
                case 20: {
                    switch (c) {
                        case '+': {
                            currentLexState = 21;
                            continue block39;
                        }
                        case '-': {
                            numberMinuses |= 1;
                            currentLexState = 21;
                            continue block39;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            to.setExp(to.exp() * 10 + (c - 48));
                            currentLexState = 22;
                            continue block39;
                        }
                    }
                    throw new IllegalArgumentException("Incorrect number. Unexpected char '" + c + "' at the position " + pos);
                }
                case 21: {
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            to.setExp(to.exp() * 10 + (c - 48));
                            currentLexState = 22;
                            continue block39;
                        }
                    }
                    throw new IllegalArgumentException("Incorrect number. Unexpected char '" + c + "' at the position " + pos);
                }
                case 22: {
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            to.setExp(to.exp() * 10 + (c - 48));
                            continue block39;
                        }
                    }
                    throw new IllegalArgumentException("Incorrect number. Unexpected char '" + c + "' at the position " + pos);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        JsonParser.setNumber(to, numberMinuses, numberMantissaExp);
    }

    public JsonParser() {
        this(new CopyingStringBuilder());
    }

    public JsonParser(JsonStringBuilder stringBuilder) {
        this.string = stringBuilder;
        this.currentLexemaPosition = -2;
        this.currentLexemaState = 23;
        this.pushScope(0);
    }

    public boolean isNotifyObjectMemberNameString() {
        return this.notifyObjectMemberNameString;
    }

    public JsonParser setNotifyObjectMemberNameString(boolean notifyObjectMemberNameString) {
        this.notifyObjectMemberNameString = notifyObjectMemberNameString;
        return this;
    }

    public JsonParser setListener(JsonParserListener listener) {
        this.listener = listener;
        return this;
    }

    public String getError() {
        return this.error;
    }

    public int getErrorPosition() {
        return this.errorPosition;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public void parseAndEoj(CharSequence data) {
        this.parse(data);
        this.eoj();
    }

    public Next parse(CharSequence data) {
        return this.parse(data, 0, data.length());
    }

    public Next parse(CharSequence data, int start, int len) {
        this.currentData = data;
        this.currentStart = start;
        this.currentLen = len;
        this.currentPos = 0;
        return this.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Next next() {
        lnr = this.listener;
        if (!JsonParser.$assertionsDisabled && lnr == null) {
            throw new AssertionError();
        }
        currentLexPos = this.currentLexemaPosition;
        if (currentLexPos < 0) {
            if (currentLexPos < -1) {
                this.doReset();
            }
            lnr.onJsonStarted();
        }
        currentLexState = this.currentLexemaState;
        stringBuilder = this.string;
        data = this.currentData;
        start = this.currentStart;
        len = this.currentLen;
        try {
            block169: for (pos = this.currentPos; pos < len; ++pos) {
                block206: {
                    c = data.charAt(start + pos);
                    if (currentLexState < 23) break block206;
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block169;
                        }
                        case '{': {
                            currentLexPos = pos++;
                            currentLexState = 24;
                            r = this.onCurlyBracketLeft(lnr, currentLexPos);
                            if (r == 0) continue block169;
                            if (r > 0) break block169;
                            var11_36 = null;
                            return var11_36;
                        }
                        case '}': {
                            currentLexPos = pos++;
                            currentLexState = 25;
                            r = this.onCurlyBracketRight(lnr, currentLexPos);
                            if (r == 0) continue block169;
                            if (r > 0) break block169;
                            var11_37 = null;
                            return var11_37;
                        }
                        case '[': {
                            currentLexPos = pos++;
                            currentLexState = 26;
                            r = this.onBoxBracketLeft(lnr, currentLexPos);
                            if (r == 0) continue block169;
                            if (r > 0) break block169;
                            var11_38 = null;
                            return var11_38;
                        }
                        case ']': {
                            currentLexPos = pos++;
                            currentLexState = 27;
                            r = this.onBoxBracketRight(lnr, currentLexPos);
                            if (r == 0) continue block169;
                            if (r > 0) break block169;
                            var11_39 = null;
                            return var11_39;
                        }
                        case ',': {
                            currentLexPos = pos;
                            currentLexState = 28;
                            r = this.onComma(currentLexPos);
                            if (r == 0) continue block169;
                            var11_40 = null;
                            return var11_40;
                        }
                        case ':': {
                            currentLexPos = pos;
                            currentLexState = 29;
                            r = this.onColon(currentLexPos);
                            if (r == 0) continue block169;
                            var11_41 = null;
                            return var11_41;
                        }
                        case 't': {
                            if (currentLexState > 31) {
                                this.error("'true' expected", pos);
                                r = null;
                                return r;
                            }
                            currentLexPos = pos;
                            if (len - pos > 3) {
                                if (data.charAt(++pos + start) == 'r' && data.charAt(++pos + start) == 'u' && data.charAt(++pos + start) == 'e') {
                                    currentLexState = 32;
                                    r = this.onTrue(lnr, currentLexPos);
                                    if (r == 0) continue block169;
                                    if (r > 0) {
                                        ++pos;
                                        break block169;
                                    }
                                    var11_42 = null;
                                    return var11_42;
                                }
                                this.error("'true' expected", currentLexPos);
                                r = null;
                                return r;
                            }
                            currentLexState = 1;
                            continue block169;
                        }
                        case 'f': {
                            if (currentLexState > 31) {
                                this.error("'false' expected", pos);
                                r = null;
                                return r;
                            }
                            currentLexPos = pos;
                            if (len - pos > 4) {
                                if (data.charAt(++pos + start) == 'a' && data.charAt(++pos + start) == 'l' && data.charAt(++pos + start) == 's' && data.charAt(++pos + start) == 'e') {
                                    currentLexState = 33;
                                    r = this.onFalse(lnr, currentLexPos);
                                    if (r == 0) continue block169;
                                    if (r > 0) {
                                        ++pos;
                                        break block169;
                                    }
                                    var11_43 = null;
                                    return var11_43;
                                }
                                this.error("'false' expected", currentLexPos);
                                r = null;
                                return r;
                            }
                            currentLexState = 4;
                            continue block169;
                        }
                        case 'n': {
                            if (currentLexState > 31) {
                                this.error("'null' expected", pos);
                                r = null;
                                return r;
                            }
                            currentLexPos = pos;
                            if (len - pos > 3) {
                                if (data.charAt(++pos + start) == 'u' && data.charAt(++pos + start) == 'l' && data.charAt(++pos + start) == 'l') {
                                    currentLexState = 34;
                                    r = this.onNull(lnr, currentLexPos);
                                    if (r == 0) continue block169;
                                    if (r > 0) {
                                        ++pos;
                                        break block169;
                                    }
                                    var11_44 = null;
                                    return var11_44;
                                }
                                this.error("'null' expected", currentLexPos);
                                r = null;
                                return r;
                            }
                            currentLexState = 8;
                            continue block169;
                        }
                        case '\"': {
                            stringBuilder.start(data, start + pos);
                            currentLexPos = pos;
                            if (len - pos > 1) {
                                startStringPos = ++pos;
                                block170: while (true) {
                                    c = data.charAt(start + pos);
                                    switch (c) {
                                        case '\"': {
                                            stringBuilder.append(data, start + startStringPos, pos - startStringPos);
                                            currentLexState = 30;
                                            r = this.onStringReady(lnr, currentLexPos);
                                            if (r == 0) continue block169;
                                            if (r > 0) {
                                                ++pos;
                                                break block169;
                                            }
                                            var12_59 = null;
                                            return var12_59;
                                        }
                                        case '\\': {
                                            stringBuilder.append(data, startStringPos, pos - startStringPos);
                                            stringBuilder.appendEscape();
                                            currentLexState = 12;
                                            continue block169;
                                        }
                                        default: {
                                            if (++pos != len) continue block170;
                                            stringBuilder.append(data, startStringPos, pos - startStringPos);
                                            break block170;
                                        }
                                    }
                                    break;
                                }
                            }
                            currentLexState = 11;
                            continue block169;
                        }
                        case '-': {
                            this.number.setMantissa(0L);
                            this.number.setExp(0);
                            this.numberMantissaExp = 0;
                            this.numberMinuses = 2;
                            currentLexPos = pos;
                            currentLexState = 17;
                            continue block169;
                        }
                        case '+': {
                            this.number.setMantissa(0L);
                            this.number.setExp(0);
                            this.numberMantissaExp = 0;
                            this.numberMinuses = 0;
                            currentLexPos = pos;
                            currentLexState = 17;
                            continue block169;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.number.setMantissa(c - 48);
                            this.number.setExp(0);
                            this.numberMantissaExp = 0;
                            this.numberMinuses = 0;
                            currentLexPos = pos;
                            if (len - pos > 1) {
                                ++pos;
                                while ((c = data.charAt(start + pos)) >= '0' && c <= '9') {
                                    this.number.setMantissa(this.number.mantissa() * 10L + (long)(c - 48));
                                    if (++pos != len) continue;
                                    ** GOTO lbl208
                                }
                                switch (c) {
                                    case '.': {
                                        currentLexState = 19;
                                        continue block169;
                                    }
                                    case 'E': 
                                    case 'e': {
                                        currentLexState = 20;
                                        continue block169;
                                    }
                                    case '\t': 
                                    case '\n': 
                                    case '\r': 
                                    case ' ': 
                                    case ',': 
                                    case ':': 
                                    case '[': 
                                    case ']': 
                                    case '{': 
                                    case '}': {
                                        --pos;
                                        currentLexState = 31;
                                        r = this.onNumber(lnr, currentLexPos);
                                        if (r == 0) continue block169;
                                        if (r > 0) {
                                            ++pos;
                                            break block169;
                                        }
                                        r = null;
                                        return r;
                                    }
                                    default: {
                                        this.error("Incorrect number", pos);
                                        r = null;
                                        return r;
                                    }
                                }
                            }
lbl208:
                            // 3 sources

                            currentLexState = 18;
                            continue block169;
                        }
                        default: {
                            this.error("Unexpected char", pos);
                            r = null;
                            return r;
                        }
                    }
                }
                switch (currentLexState) {
                    case 11: {
                        startStringPos = pos;
                        while (true) {
                            switch (c) {
                                case '\"': {
                                    stringBuilder.append(data, startStringPos, pos - startStringPos);
                                    currentLexState = 30;
                                    r = this.onStringReady(lnr, currentLexPos);
                                    if (r == 0) continue block169;
                                    if (r > 0) {
                                        ++pos;
                                        break block169;
                                    }
                                    var12_60 = null;
                                    return var12_60;
                                }
                                case '\\': {
                                    stringBuilder.append(data, startStringPos, pos - startStringPos);
                                    stringBuilder.appendEscape();
                                    currentLexState = 12;
                                    continue block169;
                                }
                                default: {
                                    if (++pos == len) {
                                        stringBuilder.append(data, startStringPos, pos - startStringPos);
                                        continue block169;
                                    }
                                    c = data.charAt(start + pos);
                                    break;
                                }
                            }
                        }
                    }
                    case 12: {
                        switch (c) {
                            case '\"': {
                                stringBuilder.appendEscapedQuotationMark();
                                currentLexState = 11;
                                continue block169;
                            }
                            case '\\': {
                                stringBuilder.appendEscapedReverseSolidus();
                                currentLexState = 11;
                                continue block169;
                            }
                            case '/': {
                                stringBuilder.appendEscapedSolidus();
                                currentLexState = 11;
                                continue block169;
                            }
                            case 'b': {
                                stringBuilder.appendEscapedBackspace();
                                currentLexState = 11;
                                continue block169;
                            }
                            case 'f': {
                                stringBuilder.appendEscapedFormfeed();
                                currentLexState = 11;
                                continue block169;
                            }
                            case 'n': {
                                stringBuilder.appendEscapedNewLine();
                                currentLexState = 11;
                                continue block169;
                            }
                            case 'r': {
                                stringBuilder.appendEscapedCarriageReturn();
                                currentLexState = 11;
                                continue block169;
                            }
                            case 't': {
                                stringBuilder.appendEscapedHorisontalTab();
                                currentLexState = 11;
                                continue block169;
                            }
                            case 'u': {
                                stringBuilder.appendEscapedUnicodeU();
                                currentLexState = 13;
                                continue block169;
                            }
                        }
                        this.error("Incorrect character escaping", pos);
                        startStringPos = null;
                        return startStringPos;
                    }
                    case 13: {
                        if (stringBuilder.appendEscapedUnicodeChar1(c)) {
                            currentLexState = 14;
                            continue block169;
                        }
                        this.error("Incorrect unicode escaping", pos);
                        startStringPos = null;
                        return startStringPos;
                    }
                    case 14: {
                        if (stringBuilder.appendEscapedUnicodeChar2(c)) {
                            currentLexState = 15;
                            continue block169;
                        }
                        this.error("Incorrect unicode escaping", pos);
                        startStringPos = null;
                        return startStringPos;
                    }
                    case 15: {
                        if (stringBuilder.appendEscapedUnicodeChar3(c)) {
                            currentLexState = 16;
                            continue block169;
                        }
                        this.error("Incorrect unicode escaping", pos);
                        startStringPos = null;
                        return startStringPos;
                    }
                    case 16: {
                        if (stringBuilder.appendEscapedUnicodeChar4(c)) {
                            currentLexState = 11;
                            continue block169;
                        }
                        this.error("Incorrect unicode escaping", pos);
                        startStringPos = null;
                        return startStringPos;
                    }
                    case 18: {
                        while (c >= '0' && c <= '9') {
                            this.number.setMantissa(this.number.mantissa() * 10L + (long)(c - 48));
                            if (++pos == len) break block169;
                            c = data.charAt(start + pos);
                        }
                        switch (c) {
                            case '.': {
                                currentLexState = 19;
                                continue block169;
                            }
                            case 'E': 
                            case 'e': {
                                currentLexState = 20;
                                continue block169;
                            }
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': 
                            case ',': 
                            case ':': 
                            case '[': 
                            case ']': 
                            case '{': 
                            case '}': {
                                --pos;
                                currentLexState = 31;
                                r = this.onNumber(lnr, currentLexPos);
                                if (r == 0) continue block169;
                                if (r > 0) {
                                    ++pos;
                                    break block169;
                                }
                                var11_47 = null;
                                return var11_47;
                            }
                            default: {
                                this.error("Incorrect number", pos);
                                var11_48 = null;
                                return var11_48;
                            }
                        }
                    }
                    case 17: {
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.number.setMantissa(this.number.mantissa() * 10L + (long)(c - 48));
                                currentLexState = 18;
                                continue block169;
                            }
                        }
                        this.error("Incorrect number", pos);
                        r = null;
                        return r;
                    }
                    case 19: {
                        while (c >= '0' && c <= '9') {
                            this.number.setMantissa(this.number.mantissa() * 10L + (long)(c - 48));
                            --this.numberMantissaExp;
                            if (++pos == len) break block169;
                            c = data.charAt(start + pos);
                        }
                        switch (c) {
                            case 'E': 
                            case 'e': {
                                currentLexState = 20;
                                continue block169;
                            }
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': 
                            case ',': 
                            case ':': 
                            case '[': 
                            case ']': 
                            case '{': 
                            case '}': {
                                --pos;
                                currentLexState = 31;
                                r = this.onNumber(lnr, currentLexPos);
                                if (r == 0) continue block169;
                                if (r > 0) {
                                    ++pos;
                                    break block169;
                                }
                                var11_49 = null;
                                return var11_49;
                            }
                            default: {
                                this.error("Incorrect number", pos);
                                var11_50 = null;
                                return var11_50;
                            }
                        }
                    }
                    case 20: {
                        switch (c) {
                            case '+': {
                                currentLexState = 21;
                                continue block169;
                            }
                            case '-': {
                                this.numberMinuses |= 1;
                                currentLexState = 21;
                                continue block169;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.number.setExp(this.number.exp() * 10 + (c - 48));
                                currentLexState = 22;
                                continue block169;
                            }
                        }
                        this.error("Incorrect number", pos);
                        r = null;
                        return r;
                    }
                    case 21: {
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.number.setExp(this.number.exp() * 10 + (c - 48));
                                currentLexState = 22;
                                continue block169;
                            }
                        }
                        this.error("Incorrect number", pos);
                        r = null;
                        return r;
                    }
                    case 22: {
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.number.setExp(this.number.exp() * 10 + (c - 48));
                                currentLexState = 22;
                                continue block169;
                            }
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': 
                            case ',': 
                            case ':': 
                            case '[': 
                            case ']': 
                            case '{': 
                            case '}': {
                                --pos;
                                currentLexState = 31;
                                r = this.onNumber(lnr, currentLexPos);
                                if (r == 0) continue block169;
                                if (r > 0) {
                                    ++pos;
                                    break block169;
                                }
                                var11_51 = null;
                                return var11_51;
                            }
                            default: {
                                this.error("Incorrect number", pos);
                                var11_52 = null;
                                return var11_52;
                            }
                        }
                    }
                    case 1: {
                        switch (c) {
                            case 'r': {
                                currentLexState = 2;
                                continue block169;
                            }
                        }
                        this.error("'true' expected", pos);
                        r = null;
                        return r;
                    }
                    case 2: {
                        switch (c) {
                            case 'u': {
                                currentLexState = 3;
                                continue block169;
                            }
                        }
                        this.error("'true' expected", pos);
                        r = null;
                        return r;
                    }
                    case 3: {
                        switch (c) {
                            case 'e': {
                                currentLexState = 32;
                                r = this.onTrue(lnr, currentLexPos);
                                if (r == 0) continue block169;
                                if (r > 0) {
                                    ++pos;
                                    break block169;
                                }
                                var11_53 = null;
                                return var11_53;
                            }
                            default: {
                                this.error("'true' expected", pos);
                                var11_54 = null;
                                return var11_54;
                            }
                        }
                    }
                    case 4: {
                        switch (c) {
                            case 'a': {
                                currentLexState = 5;
                                continue block169;
                            }
                        }
                        this.error("'false' expected", pos);
                        r = null;
                        return r;
                    }
                    case 5: {
                        switch (c) {
                            case 'l': {
                                currentLexState = 6;
                                continue block169;
                            }
                        }
                        this.error("'false' expected", pos);
                        r = null;
                        return r;
                    }
                    case 6: {
                        switch (c) {
                            case 's': {
                                currentLexState = 7;
                                continue block169;
                            }
                        }
                        this.error("'false' expected", pos);
                        r = null;
                        return r;
                    }
                    case 7: {
                        switch (c) {
                            case 'e': {
                                currentLexState = 33;
                                r = this.onFalse(lnr, currentLexPos);
                                if (r == 0) continue block169;
                                if (r > 0) {
                                    ++pos;
                                    break block169;
                                }
                                var11_55 = null;
                                return var11_55;
                            }
                            default: {
                                this.error("'false' expected", pos);
                                var11_56 = null;
                                return var11_56;
                            }
                        }
                    }
                    case 8: {
                        switch (c) {
                            case 'u': {
                                currentLexState = 9;
                                continue block169;
                            }
                        }
                        this.error("'null' expected", pos);
                        r = null;
                        return r;
                    }
                    case 9: {
                        switch (c) {
                            case 'l': {
                                currentLexState = 10;
                                continue block169;
                            }
                        }
                        this.error("'null' expected", pos);
                        r = null;
                        return r;
                    }
                    case 10: {
                        switch (c) {
                            case 'l': {
                                currentLexState = 34;
                                r = this.onNull(lnr, currentLexPos);
                                if (r == 0) continue block169;
                                if (r > 0) {
                                    ++pos;
                                    break block169;
                                }
                                var11_57 = null;
                                return var11_57;
                            }
                            default: {
                                this.error("'null' expected", pos);
                                var11_58 = null;
                                return var11_58;
                            }
                        }
                    }
                    default: {
                        this.error("Internal error. Unexpected lexema", pos);
                        var10_34 = null;
                        return var10_34;
                    }
                }
            }
            var9_10 = pos < len ? this.next : null;
            return var9_10;
        }
        finally {
            this.currentPos = pos;
            this.currentLexemaState = currentLexState;
            this.currentLexemaPosition = currentLexPos;
        }
    }

    public JsonParser eoj() {
        JsonParserListener lnr = this.listener;
        if (lnr != null) {
            if (this.error == null) {
                this.onEoj(lnr, this.currentLexemaPosition);
            }
            lnr.onJsonEnded();
        }
        this.currentLexemaPosition = -2;
        return this;
    }

    public JsonParser reset() {
        this.doReset();
        this.currentLexemaPosition = -1;
        return this;
    }

    private void doReset() {
        this.currentLexemaState = 23;
        this.clearScope();
        this.pushScope(0);
        this.error = null;
    }

    private void error(String error, int position) {
        JsonParserListener lnr = this.listener;
        assert (lnr != null);
        this.error = error;
        this.errorPosition = position;
        lnr.onError(error, position);
    }

    private static void setNumber(MutableJsonNumber number, int numberMinuses, int numberMantissaExp) {
        if ((numberMinuses & 2) != 0) {
            number.setMantissa(-number.mantissa());
        }
        if ((numberMinuses & 1) != 0) {
            number.setExp(-number.exp());
        }
        number.setExp(number.exp() + numberMantissaExp);
    }

    private int onCurlyBracketLeft(JsonParserListener lnr, int lexemaPosition) {
        int currentScope = this.peekScope();
        switch (currentScope) {
            case 0: {
                boolean r = lnr.onObjectStarted();
                this.replaceScope(1);
                if (r) break;
                return 1;
            }
            case 3: {
                boolean r = lnr.onObjectStarted();
                this.replaceScope(4);
                this.pushScope(1);
                if (r) break;
                return 1;
            }
            case 6: 
            case 8: {
                boolean r = lnr.onObjectStarted();
                this.replaceScope(7);
                this.pushScope(1);
                if (r) break;
                return 1;
            }
            default: {
                this.error(ERROR_UNEXPECTED_CURLY_BRACKET_LEFT_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private int onCurlyBracketRight(JsonParserListener lnr, int lexemaPosition) {
        int currentScope = this.peekScope();
        switch (currentScope) {
            case 1: 
            case 5: {
                boolean r = lnr.onObjectEnded();
                this.popScope();
                if (r) break;
                return 1;
            }
            case 4: {
                boolean r = lnr.onObjectEnded();
                this.popScope();
                if (r) break;
                return 1;
            }
            default: {
                this.error(ERROR_UNEXPECTED_CURLY_BRACKET_RIGHT_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private int onBoxBracketLeft(JsonParserListener lnr, int lexemaPosition) {
        int currentScope = this.peekScope();
        switch (currentScope) {
            case 0: {
                boolean r = lnr.onArrayStarted();
                this.replaceScope(6);
                if (r) break;
                return 1;
            }
            case 3: {
                boolean r = lnr.onArrayStarted();
                this.replaceScope(4);
                this.pushScope(6);
                if (r) break;
                return 1;
            }
            case 6: 
            case 8: {
                boolean r = lnr.onArrayStarted();
                this.replaceScope(7);
                this.pushScope(6);
                if (r) break;
                return 1;
            }
            default: {
                this.error(ERROR_UNEXPECTED_BOX_BRACKET_LEFT_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private int onBoxBracketRight(JsonParserListener lnr, int lexemaPosition) {
        int currentScope = this.peekScope();
        switch (currentScope) {
            case 6: 
            case 8: {
                boolean r = lnr.onArrayEnded();
                this.popScope();
                if (r) break;
                return 1;
            }
            case 7: {
                boolean r = lnr.onArrayEnded();
                this.popScope();
                if (r) break;
                return 1;
            }
            default: {
                this.error(ERROR_UNEXPECTED_BOX_BRACKET_RIGHT_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private int onComma(int lexemaPosition) {
        int currentScope = this.peekScope();
        switch (currentScope) {
            case 4: {
                this.replaceScope(5);
                break;
            }
            case 7: {
                this.replaceScope(8);
                break;
            }
            default: {
                this.error(ERROR_UNEXPECTED_COMMA_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private int onColon(int lexemaPosition) {
        int currentScope = this.peekScope();
        switch (currentScope) {
            case 2: {
                this.replaceScope(3);
                break;
            }
            default: {
                this.error(ERROR_UNEXPECTED_COLON_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private int onStringReady(JsonParserListener lnr, int lexemaPosition) {
        int currentScope = this.peekScope();
        JsonStringBuilder value = this.string;
        switch (currentScope) {
            case 0: {
                boolean r = lnr.onStringValue(value);
                this.popScope();
                if (r) break;
                return 1;
            }
            case 1: 
            case 5: {
                boolean r = lnr.onObjectMember(value);
                if (this.notifyObjectMemberNameString) {
                    lnr.onStringValue(value);
                }
                this.replaceScope(2);
                if (r) break;
                return 1;
            }
            case 3: {
                boolean r = lnr.onStringValue(value);
                this.replaceScope(4);
                if (r) break;
                return 1;
            }
            case 6: 
            case 8: {
                boolean r = lnr.onStringValue(value);
                this.replaceScope(7);
                if (r) break;
                return 1;
            }
            default: {
                this.error(ERROR_UNEXPECTED_STRING_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private int onNumber(JsonParserListener lnr, int lexemaPosition) {
        JsonParser.setNumber(this.number, this.numberMinuses, this.numberMantissaExp);
        int currentScope = this.peekScope();
        switch (currentScope) {
            case 0: {
                boolean r = lnr.onNumberValue(this.number);
                this.popScope();
                if (r) break;
                return 1;
            }
            case 3: {
                boolean r = lnr.onNumberValue(this.number);
                this.replaceScope(4);
                if (r) break;
                return 1;
            }
            case 6: 
            case 8: {
                boolean r = lnr.onNumberValue(this.number);
                this.replaceScope(7);
                if (r) break;
                return 1;
            }
            default: {
                this.error(ERROR_UNEXPECTED_NUMBER_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private int onTrue(JsonParserListener lnr, int lexemaPosition) {
        int currentScope = this.peekScope();
        switch (currentScope) {
            case 0: {
                boolean r = lnr.onTrueValue();
                this.popScope();
                if (r) break;
                return 1;
            }
            case 3: {
                boolean r = lnr.onTrueValue();
                this.replaceScope(4);
                if (r) break;
                return 1;
            }
            case 6: 
            case 8: {
                boolean r = lnr.onTrueValue();
                this.replaceScope(7);
                if (r) break;
                return 1;
            }
            default: {
                this.error(ERROR_UNEXPECTED_TRUE_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private int onFalse(JsonParserListener lnr, int lexemaPosition) {
        int currentScope = this.peekScope();
        switch (currentScope) {
            case 0: {
                boolean r = lnr.onFalseValue();
                this.popScope();
                if (r) break;
                return 1;
            }
            case 3: {
                boolean r = lnr.onFalseValue();
                this.replaceScope(4);
                if (r) break;
                return 1;
            }
            case 6: 
            case 8: {
                boolean r = lnr.onFalseValue();
                this.replaceScope(7);
                if (r) break;
                return 1;
            }
            default: {
                this.error(ERROR_UNEXPECTED_FALSE_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private int onNull(JsonParserListener lnr, int lexemaPosition) {
        int currentScope = this.peekScope();
        switch (currentScope) {
            case 0: {
                boolean r = lnr.onNullValue();
                this.popScope();
                if (r) break;
                return 1;
            }
            case 3: {
                boolean r = lnr.onNullValue();
                this.replaceScope(4);
                if (r) break;
                return 1;
            }
            case 6: 
            case 8: {
                boolean r = lnr.onNullValue();
                this.replaceScope(7);
                if (r) break;
                return 1;
            }
            default: {
                this.error(ERROR_UNEXPECTED_NULL_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private int onEoj(JsonParserListener lnr, int lexemaPosition) {
        int currentScope = this.peekScope();
        switch (currentScope) {
            case -1: {
                break;
            }
            case 0: {
                switch (this.currentLexemaState) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.error(ERROR_TRUE_EXPECTED_MESSAGE, lexemaPosition);
                        return -1;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.error(ERROR_FALSE_EXPECTED_MESSAGE, lexemaPosition);
                        return -1;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        this.error(ERROR_NULL_EXPECTED_MESSAGE, lexemaPosition);
                        return -1;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        this.error(ERROR_INCORRECT_STRING_MESSAGE, lexemaPosition);
                        return -1;
                    }
                    case 17: 
                    case 20: 
                    case 21: {
                        this.error(ERROR_INCORRECT_NUMBER_MESSAGE, lexemaPosition);
                        return -1;
                    }
                    case 18: 
                    case 19: 
                    case 22: {
                        JsonParser.setNumber(this.number, this.numberMinuses, this.numberMantissaExp);
                        lnr.onNumberValue(this.number);
                        this.popScope();
                    }
                }
                break;
            }
            default: {
                this.error(ERROR_INTERNAL_UNEXPECTED_LEXEMA_ERROR_MESSAGE, lexemaPosition);
                return -1;
            }
        }
        return 0;
    }

    private void clearScope() {
        this.scopeStackDepth = 0;
    }

    private void pushScope(int expression) {
        int depth = this.scopeStackDepth;
        int[] stack = this.scopeStack;
        if (depth == stack.length) {
            stack = new int[stack.length << 1];
            System.arraycopy(this.scopeStack, 0, stack, 0, this.scopeStack.length);
            this.scopeStack = stack;
        }
        stack[depth++] = expression;
        this.scopeStackDepth = depth;
    }

    private int popScope() {
        assert (this.scopeStackDepth > 0);
        return this.scopeStack[--this.scopeStackDepth];
    }

    private int peekScope() {
        if (this.scopeStackDepth < 1) {
            return -1;
        }
        return this.scopeStack[this.scopeStackDepth - 1];
    }

    private void replaceScope(int expression) {
        assert (this.scopeStackDepth > 0);
        this.scopeStack[this.scopeStackDepth - 1] = expression;
    }

    public static interface Next {
        public Next next();
    }
}

