/*
 * Decompiled with CFR 0.152.
 */
package io.github.green4j.jelly;

import io.github.green4j.jelly.JsonBufferedWriter;
import io.github.green4j.jelly.JsonNumber;

public final class JsonGenerator {
    private static final String NL;
    private static final String[] WSS;
    private static final char[] DIGIT_TENS;
    private static final char[] DIGIT_ONES;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NULL = "null";
    private static final String[] UNICODE_ASCII_LOW;
    private static final String UNICODE_2028 = "\\u2028";
    private static final String UNICODE_2029 = "\\u2029";
    private static final int STATE_OBJECT_STARTED = 1;
    private static final int STATE_OBJECT_MEMBER_NAME = 2;
    private static final int STATE_OBJECT_MEMBER_VALUE = 3;
    private static final int STATE_ARRAY_STARTED = 4;
    private static final int STATE_ARRAY_ITEM = 5;
    private static final int MAX_NUMBER_OF_DIGITS = 19;
    private static final int DECIMAL_FORMAT_NO_POINT = 0;
    private static final int DECIMAL_FORMAT_INSIDE_MANTISSA = 1;
    private static final int DECIMAL_FORMAT_BEFORE_MANTISSA = 2;
    private static final int DECIMAL_FORMAT_EXP = 3;
    static final char[] HEX_DIGITS;
    private final boolean indent;
    private int[] scopeStack = new int[8];
    private int scopeStackDepth;
    private JsonBufferedWriter output;

    public JsonGenerator() {
        this(true);
    }

    public JsonGenerator(boolean indent) {
        this.indent = indent;
    }

    public JsonGenerator(JsonBufferedWriter output) {
        this(output, true);
    }

    public JsonGenerator(JsonBufferedWriter output, boolean indent) {
        this(indent);
        this.output = output;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public JsonGenerator setOutput(JsonBufferedWriter output) {
        this.output = output;
        return this;
    }

    public void startObject() {
        this.writeStructureStarted('{', 1);
    }

    public void objectMember(CharSequence name) {
        this.objectMember(name, 0, name.length());
    }

    public void objectMember(CharSequence name, int start, int len) {
        JsonBufferedWriter out = this.output;
        assert (out != null);
        int scope = this.peekScope();
        switch (scope) {
            case 2: 
            case 3: {
                out.append(',');
            }
        }
        if (this.indent) {
            this.indent(out, false);
        }
        out.append('\"');
        out.append(name, start, start + len);
        out.append("\":");
        this.replaceScope(2);
    }

    public void endObject() {
        this.writeStructureEnded('}');
    }

    public void startArray() {
        this.writeStructureStarted('[', 4);
    }

    public void endArray() {
        this.writeStructureEnded(']');
    }

    public void stringValue(CharSequence value, boolean escaping) {
        this.writeStringQuoted(value, 0, value.length(), escaping);
    }

    public void stringValue(CharSequence value) {
        this.writeStringQuoted(value, 0, value.length(), false);
    }

    public void stringValue(CharSequence name, int start, int len, boolean escaping) {
        this.writeStringQuoted(name, start, len, escaping);
    }

    public void stringValue(CharSequence name, int start, int len) {
        this.writeStringQuoted(name, start, len, false);
    }

    public void numberValueAsString(JsonNumber value) {
        this.numberValueAsString(value.mantissa(), value.exp());
    }

    public void numberValueAsString(long value) {
        this.numberValueAsString(value, 0);
    }

    public void numberValueAsString(long mantissa, int exp) {
        this.writeNumberQuoted(mantissa, exp);
    }

    public void numberValue(long value) {
        this.numberValue(value, 0);
    }

    public void numberValue(JsonNumber value) {
        this.numberValue(value.mantissa(), value.exp());
    }

    public void numberValue(long mantissa, int exp) {
        JsonBufferedWriter out = this.output;
        assert (out != null);
        int scope = this.peekScope();
        this.beforeLiteralAdded(scope, out);
        if (exp == 0) {
            JsonGenerator.writeLongNumber(out, mantissa);
        } else {
            JsonGenerator.writeDecimalNumber(out, mantissa, exp);
        }
        this.afterValueAdded(scope);
    }

    public void trueValue() {
        this.writeStringDirect(TRUE);
    }

    public void falseValue() {
        this.writeStringDirect(FALSE);
    }

    public void nullValue() {
        this.writeStringDirect(NULL);
    }

    public void eoj() {
        block4: while (this.scopeStackDepth > 0) {
            int scope = this.peekScope();
            switch (scope) {
                case 4: 
                case 5: {
                    this.endArray();
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.endObject();
                    continue block4;
                }
            }
            throw new IllegalStateException("Internal error. Unexpected state: " + scope);
        }
        this.output.flush();
        this.reset();
    }

    public void reset() {
        this.clearScope();
    }

    private void writeStructureStarted(char leftBracket, int newState) {
        JsonBufferedWriter out = this.output;
        assert (out != null);
        int scope = this.peekScope();
        switch (scope) {
            case 3: 
            case 5: {
                out.append(',');
            }
        }
        if (this.indent) {
            this.indent(out, false);
        }
        out.append(leftBracket);
        this.pushScope(newState);
    }

    private void writeStructureEnded(char rightBracket) {
        JsonBufferedWriter out = this.output;
        assert (out != null);
        this.popScope();
        if (this.indent) {
            this.indent(out, true);
        }
        out.append(rightBracket);
        this.afterValueAdded(this.peekScope());
    }

    private void writeStringQuoted(CharSequence value, int start, int len, boolean escaping) {
        JsonBufferedWriter out = this.output;
        assert (out != null);
        int scope = this.peekScope();
        this.beforeLiteralAdded(scope, out);
        out.append('\"');
        if (escaping) {
            block12: for (int i = start; i < start + len; ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\b': {
                        out.append("\\b");
                        continue block12;
                    }
                    case '\t': {
                        out.append("\\t");
                        continue block12;
                    }
                    case '\n': {
                        out.append("\\n");
                        continue block12;
                    }
                    case '\f': {
                        out.append("\\f");
                        continue block12;
                    }
                    case '\r': {
                        out.append("\\r");
                        continue block12;
                    }
                    case '/': {
                        out.append("\\/");
                        continue block12;
                    }
                    case '\\': {
                        out.append("\\\\");
                        continue block12;
                    }
                    case '\"': {
                        out.append("\\\"");
                        continue block12;
                    }
                    case '\u2028': {
                        out.append(UNICODE_2028);
                        continue block12;
                    }
                    case '\u2029': {
                        out.append(UNICODE_2029);
                        continue block12;
                    }
                    default: {
                        if (c < UNICODE_ASCII_LOW.length) {
                            out.append(UNICODE_ASCII_LOW[c]);
                            continue block12;
                        }
                        out.append(c);
                    }
                }
            }
        } else {
            out.append(value, start, start + len);
        }
        out.append("\"");
        this.afterValueAdded(scope);
    }

    private void writeStringDirect(String value) {
        JsonBufferedWriter out = this.output;
        assert (out != null);
        int scope = this.peekScope();
        this.beforeLiteralAdded(scope, out);
        out.append(value);
        this.afterValueAdded(scope);
    }

    private void writeNumberQuoted(long mantissa, int exp) {
        JsonBufferedWriter out = this.output;
        assert (out != null);
        int scope = this.peekScope();
        this.beforeLiteralAdded(scope, out);
        out.append('\"');
        if (exp == 0) {
            JsonGenerator.writeLongNumber(out, mantissa);
        } else {
            JsonGenerator.writeDecimalNumber(out, mantissa, exp);
        }
        out.append("\"");
        this.afterValueAdded(scope);
    }

    private void beforeLiteralAdded(int scope, JsonBufferedWriter out) {
        switch (scope) {
            case 5: {
                out.append(',');
            }
        }
        if (this.indent) {
            switch (scope) {
                case 4: 
                case 5: {
                    this.indent(out, false);
                    break;
                }
                case 2: {
                    out.append(' ');
                }
            }
        }
    }

    private void afterValueAdded(int scope) {
        switch (scope) {
            case 2: {
                this.replaceScope(3);
                break;
            }
            case 4: {
                this.replaceScope(5);
            }
        }
    }

    private void indent(JsonBufferedWriter out, boolean ending) {
        int depth = this.scopeStackDepth;
        if (depth == 0) {
            if (ending) {
                out.append(NL);
            }
            return;
        }
        out.append(NL);
        int delta = depth - WSS.length;
        if (delta > -1) {
            out.append(WSS[WSS.length - 1]);
            for (int i = 0; i < delta + 1; ++i) {
                out.append(WSS[1]);
            }
        } else {
            out.append(WSS[depth]);
        }
    }

    private void clearScope() {
        this.scopeStackDepth = 0;
    }

    private void pushScope(int scope) {
        if (this.scopeStackDepth == this.scopeStack.length) {
            int[] newScopeStack = new int[this.scopeStack.length << 1];
            System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
            this.scopeStack = newScopeStack;
        }
        this.scopeStack[this.scopeStackDepth++] = scope;
    }

    private int popScope() {
        assert (this.scopeStackDepth > 0);
        return this.scopeStack[--this.scopeStackDepth];
    }

    private int peekScope() {
        if (this.scopeStackDepth < 1) {
            return -1;
        }
        return this.scopeStack[this.scopeStackDepth - 1];
    }

    private void replaceScope(int scope) {
        assert (this.scopeStackDepth > 0);
        this.scopeStack[this.scopeStackDepth - 1] = scope;
    }

    private static void writeLongNumber(JsonBufferedWriter out, long mantissa) {
        int size;
        long mts = mantissa;
        if (mts == Long.MIN_VALUE) {
            out.append("-9223372036854775808");
            return;
        }
        if (mts == 0L) {
            out.append("0");
            return;
        }
        char sgn = '\u0000';
        if (mts < 0L) {
            sgn = '-';
            mts = -mts;
            size = JsonGenerator.numberOfDigits(mts) + 1;
        } else {
            size = JsonGenerator.numberOfDigits(mts);
        }
        JsonGenerator.writeLongValueToEndOfTheFrame(out.append(size), mts, sgn);
    }

    private static void writeLongValueToEndOfTheFrame(JsonBufferedWriter.Frame buf, long mantissa, char sign) {
        int x2;
        int y;
        long mts = mantissa;
        int currentCharIndex = buf.length();
        while (mts > Integer.MAX_VALUE) {
            long x = mts / 100L;
            y = (int)(mts - ((x << 6) + (x << 5) + (x << 2)));
            mts = x;
            buf.setCharAt(--currentCharIndex, DIGIT_ONES[y]);
            buf.setCharAt(--currentCharIndex, DIGIT_TENS[y]);
        }
        int mts2 = (int)mts;
        while (mts2 >= 65536) {
            x2 = mts2 / 100;
            y = mts2 - ((x2 << 6) + (x2 << 5) + (x2 << 2));
            mts2 = x2;
            buf.setCharAt(--currentCharIndex, DIGIT_ONES[y]);
            buf.setCharAt(--currentCharIndex, DIGIT_TENS[y]);
        }
        do {
            x2 = mts2 * 52429 >>> 19;
            y = mts2 - ((x2 << 3) + (x2 << 1));
            buf.setCharAt(--currentCharIndex, HEX_DIGITS[y]);
        } while ((mts2 = x2) != 0);
        if (sign != '\u0000') {
            buf.setCharAt(--currentCharIndex, sign);
        }
    }

    private static void writeDecimalNumber(JsonBufferedWriter out, long mantissa, int exp) {
        int x2;
        int y;
        int size;
        int numOfDigits;
        long mts = mantissa;
        int e = exp;
        if (mts == 0L) {
            out.append("0");
            return;
        }
        char mantissaSign = '\u0000';
        if (mts < 0L) {
            mantissaSign = '-';
            mts = -mts;
            numOfDigits = JsonGenerator.numberOfDigits(mts);
            size = numOfDigits + 1;
        } else {
            size = numOfDigits = JsonGenerator.numberOfDigits(mts);
        }
        int pointPos = e + numOfDigits;
        char expSign = '+';
        int additionalNumbers = 0;
        int expNumOfDigits = 0;
        int mode = 0;
        if (numOfDigits <= pointPos && pointPos <= 19) {
            additionalNumbers = pointPos - numOfDigits;
            size += additionalNumbers;
        } else if (0 < pointPos && pointPos <= 19 && pointPos < numOfDigits) {
            mode = 1;
            ++size;
        } else if (-6 < pointPos && pointPos <= 0) {
            mode = 2;
            size = size + 2 + -pointPos;
        } else if (pointPos <= -6 || pointPos > 19) {
            mode = 3;
            e = pointPos - 1;
            if (e < 0) {
                expSign = '-';
                e = -e;
            }
            expNumOfDigits = JsonGenerator.numberOfDigits(e);
            size = size + (numOfDigits > 1 ? 1 : 0) + 2 + expNumOfDigits;
        }
        JsonBufferedWriter.Frame buf = out.append(size);
        int currentCharIndex = size;
        switch (mode) {
            case 0: {
                for (int i = 0; i < additionalNumbers; ++i) {
                    buf.setCharAt(--currentCharIndex, '0');
                }
                break;
            }
            case 3: {
                JsonGenerator.writeLongValueToEndOfTheFrame(buf, e, expSign);
                currentCharIndex = currentCharIndex - expNumOfDigits - 1;
                buf.setCharAt(--currentCharIndex, 'e');
            }
        }
        int remainingNumCount = numOfDigits;
        while (mts > Integer.MAX_VALUE) {
            long x = mts / 100L;
            y = (int)(mts - ((x << 6) + (x << 5) + (x << 2)));
            mts = x;
            buf.setCharAt(--currentCharIndex, DIGIT_ONES[y]);
            --remainingNumCount;
            switch (mode) {
                case 1: {
                    if (remainingNumCount != pointPos) break;
                    buf.setCharAt(--currentCharIndex, '.');
                    break;
                }
                case 3: {
                    if (remainingNumCount != 1 || numOfDigits <= 1) break;
                    buf.setCharAt(--currentCharIndex, '.');
                }
            }
            buf.setCharAt(--currentCharIndex, DIGIT_TENS[y]);
            --remainingNumCount;
            switch (mode) {
                case 1: {
                    if (remainingNumCount != pointPos) break;
                    buf.setCharAt(--currentCharIndex, '.');
                    break;
                }
                case 3: {
                    if (remainingNumCount != 1 || numOfDigits <= 1) break;
                    buf.setCharAt(--currentCharIndex, '.');
                }
            }
        }
        int mantissa2 = (int)mts;
        while (mantissa2 >= 65536) {
            x2 = mantissa2 / 100;
            y = mantissa2 - ((x2 << 6) + (x2 << 5) + (x2 << 2));
            mantissa2 = x2;
            buf.setCharAt(--currentCharIndex, DIGIT_ONES[y]);
            --remainingNumCount;
            switch (mode) {
                case 1: {
                    if (remainingNumCount != pointPos) break;
                    buf.setCharAt(--currentCharIndex, '.');
                    break;
                }
                case 3: {
                    if (remainingNumCount != 1 || numOfDigits <= 1) break;
                    buf.setCharAt(--currentCharIndex, '.');
                }
            }
            buf.setCharAt(--currentCharIndex, DIGIT_TENS[y]);
            --remainingNumCount;
            switch (mode) {
                case 1: {
                    if (remainingNumCount != pointPos) break;
                    buf.setCharAt(--currentCharIndex, '.');
                    break;
                }
                case 3: {
                    if (remainingNumCount != 1 || numOfDigits <= 1) break;
                    buf.setCharAt(--currentCharIndex, '.');
                }
            }
        }
        block27: do {
            x2 = mantissa2 * 52429 >>> 19;
            y = mantissa2 - ((x2 << 3) + (x2 << 1));
            buf.setCharAt(--currentCharIndex, HEX_DIGITS[y]);
            --remainingNumCount;
            switch (mode) {
                case 1: {
                    if (remainingNumCount != pointPos) break;
                    buf.setCharAt(--currentCharIndex, '.');
                    break;
                }
                case 3: {
                    if (remainingNumCount != 1 || numOfDigits <= 1) continue block27;
                    buf.setCharAt(--currentCharIndex, '.');
                }
            }
        } while ((mantissa2 = x2) != 0);
        if (mode == 2) {
            for (int i = 0; i < -pointPos; ++i) {
                buf.setCharAt(--currentCharIndex, '0');
            }
            buf.setCharAt(--currentCharIndex, '.');
            buf.setCharAt(--currentCharIndex, '0');
        }
        if (mantissaSign != '\u0000') {
            buf.setCharAt(--currentCharIndex, mantissaSign);
        }
    }

    private static int numberOfDigits(long x) {
        assert (x >= 0L);
        if (x < 1000000L) {
            if (x < 1000L) {
                if (x < 100L) {
                    if (x < 10L) {
                        return 1;
                    }
                    return 2;
                }
                return 3;
            }
            if (x < 10000L) {
                return 4;
            }
            if (x < 100000L) {
                return 5;
            }
            return 6;
        }
        if (x < 1000000000L) {
            if (x < 100000000L) {
                if (x < 10000000L) {
                    return 7;
                }
                return 8;
            }
            return 9;
        }
        if (x < 100000000000000L) {
            if (x < 1000000000000L) {
                if (x < 10000000000L) {
                    return 10;
                }
                if (x < 100000000000L) {
                    return 11;
                }
                return 12;
            }
            if (x < 10000000000000L) {
                return 13;
            }
            return 14;
        }
        if (x < 100000000000000000L) {
            if (x < 1000000000000000L) {
                return 15;
            }
            if (x < 10000000000000000L) {
                return 16;
            }
            return 17;
        }
        if (x < 1000000000000000000L) {
            return 18;
        }
        return 19;
    }

    static {
        int i;
        NL = System.getProperty("line.separator", "\n");
        WSS = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};
        DIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        DIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        UNICODE_ASCII_LOW = new String[32];
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (i = 0; i < 16; ++i) {
            JsonGenerator.UNICODE_ASCII_LOW[i] = "\\u000" + HEX_DIGITS[i];
        }
        for (i = 16; i < UNICODE_ASCII_LOW.length; ++i) {
            JsonGenerator.UNICODE_ASCII_LOW[i] = "\\u00" + HEX_DIGITS[i >>> 4 & 0xF] + HEX_DIGITS[i & 0xF];
        }
    }
}

