/*
 * Decompiled with CFR 0.152.
 */
package io.github.green4j.jelly;

import io.github.green4j.jelly.JsonBufferedWriter;
import io.github.green4j.jelly.JsonGenerator;
import io.github.green4j.jelly.JsonNumber;
import io.github.green4j.jelly.JsonParserListener;

public class JsonEventPump
implements JsonParserListener {
    protected final StringBuilder memberName = new StringBuilder();
    protected final JsonGenerator output;

    public JsonEventPump(JsonBufferedWriter output) {
        this.output = new JsonGenerator(output);
    }

    public JsonEventPump(JsonGenerator output) {
        this.output = output;
    }

    @Override
    public void onJsonStarted() {
    }

    @Override
    public void onError(String error, int position) {
    }

    @Override
    public void onJsonEnded() {
        this.output.eoj();
    }

    @Override
    public boolean onObjectStarted() {
        this.pushMemberNameIfRequired();
        this.output.startObject();
        return true;
    }

    @Override
    public boolean onObjectMember(CharSequence name) {
        this.memberName.setLength(0);
        this.memberName.append(name);
        return true;
    }

    @Override
    public boolean onObjectEnded() {
        this.output.endObject();
        return true;
    }

    @Override
    public boolean onArrayStarted() {
        this.pushMemberNameIfRequired();
        this.output.startArray();
        return true;
    }

    @Override
    public boolean onArrayEnded() {
        this.output.endArray();
        return true;
    }

    @Override
    public boolean onStringValue(CharSequence data) {
        this.pushMemberNameIfRequired();
        this.output.stringValue(data);
        return true;
    }

    @Override
    public boolean onNumberValue(JsonNumber number) {
        this.pushMemberNameIfRequired();
        this.output.numberValue(number);
        return true;
    }

    @Override
    public boolean onTrueValue() {
        this.pushMemberNameIfRequired();
        this.output.trueValue();
        return true;
    }

    @Override
    public boolean onFalseValue() {
        this.pushMemberNameIfRequired();
        this.output.falseValue();
        return true;
    }

    @Override
    public boolean onNullValue() {
        this.pushMemberNameIfRequired();
        this.output.nullValue();
        return true;
    }

    private void pushMemberNameIfRequired() {
        if (this.memberName.length() == 0) {
            return;
        }
        this.output.objectMember(this.memberName);
        this.memberName.setLength(0);
    }
}

