/*
 * Decompiled with CFR 0.152.
 */
package io.github.green4j.jelly;

import io.github.green4j.jelly.JsonStringBuilder;

public final class FlyweightStringBuilder
implements JsonStringBuilder {
    private CharSequence buffer;
    private int start;
    private int len;

    public CharSequence buffer() {
        return this.buffer;
    }

    public int start() {
        return this.start;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        return this.buffer.charAt(this.start + index);
    }

    @Override
    public void start(CharSequence data, int position) {
        this.buffer = data;
        this.start = position + 1;
        this.len = 0;
    }

    @Override
    public void append(CharSequence data, int start, int len) {
        assert (this.buffer == data);
        this.len += len;
    }

    @Override
    public void appendEscape() {
        ++this.len;
    }

    @Override
    public void appendEscapedQuotationMark() {
        ++this.len;
    }

    @Override
    public void appendEscapedReverseSolidus() {
        ++this.len;
    }

    @Override
    public void appendEscapedSolidus() {
        ++this.len;
    }

    @Override
    public void appendEscapedBackspace() {
        ++this.len;
    }

    @Override
    public void appendEscapedFormfeed() {
        ++this.len;
    }

    @Override
    public void appendEscapedNewLine() {
        ++this.len;
    }

    @Override
    public void appendEscapedCarriageReturn() {
        ++this.len;
    }

    @Override
    public void appendEscapedHorisontalTab() {
        ++this.len;
    }

    @Override
    public void appendEscapedUnicodeU() {
        ++this.len;
    }

    @Override
    public boolean appendEscapedUnicodeChar1(char c) {
        return this.appendUnicodeChar(c);
    }

    @Override
    public boolean appendEscapedUnicodeChar2(char c) {
        return this.appendUnicodeChar(c);
    }

    @Override
    public boolean appendEscapedUnicodeChar3(char c) {
        return this.appendUnicodeChar(c);
    }

    @Override
    public boolean appendEscapedUnicodeChar4(char c) {
        return this.appendUnicodeChar(c);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        if (this.buffer == null) {
            return "null";
        }
        if (this.len == 0) {
            return "";
        }
        return new StringBuilder().append(this.buffer, this.start, this.start + this.len).toString();
    }

    private boolean appendUnicodeChar(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                ++this.len;
                return true;
            }
        }
        return false;
    }
}

