/*
 * Decompiled with CFR 0.152.
 */
package io.github.green4j.jelly;

import io.github.green4j.jelly.JsonStringBuilder;

public final class CopyingStringBuilder
implements JsonStringBuilder {
    private final StringBuilder buffer = new StringBuilder();
    private final boolean rawString;
    private int escapedUnicodeChar;

    public CopyingStringBuilder() {
        this(false);
    }

    public CopyingStringBuilder(boolean rawString) {
        this.rawString = rawString;
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    @Override
    public char charAt(int index) {
        return this.buffer.charAt(index);
    }

    @Override
    public void start(CharSequence data, int position) {
        this.buffer.setLength(0);
    }

    @Override
    public void append(CharSequence data, int start, int len) {
        this.buffer.append(data, start, start + len);
    }

    @Override
    public void appendEscape() {
        if (this.rawString) {
            this.buffer.append('\\');
        }
    }

    @Override
    public void appendEscapedQuotationMark() {
        this.buffer.append('\"');
    }

    @Override
    public void appendEscapedReverseSolidus() {
        this.buffer.append('\\');
    }

    @Override
    public void appendEscapedSolidus() {
        this.buffer.append('/');
    }

    @Override
    public void appendEscapedBackspace() {
        if (this.rawString) {
            this.buffer.append('b');
        } else {
            this.buffer.append('\b');
        }
    }

    @Override
    public void appendEscapedFormfeed() {
        if (this.rawString) {
            this.buffer.append('f');
        } else {
            this.buffer.append('\f');
        }
    }

    @Override
    public void appendEscapedNewLine() {
        if (this.rawString) {
            this.buffer.append('n');
        } else {
            this.buffer.append('\n');
        }
    }

    @Override
    public void appendEscapedCarriageReturn() {
        if (this.rawString) {
            this.buffer.append('r');
        } else {
            this.buffer.append('\r');
        }
    }

    @Override
    public void appendEscapedHorisontalTab() {
        if (this.rawString) {
            this.buffer.append('t');
        } else {
            this.buffer.append('\t');
        }
    }

    @Override
    public void appendEscapedUnicodeU() {
        if (this.rawString) {
            this.buffer.append('u');
        }
    }

    @Override
    public boolean appendEscapedUnicodeChar1(char c) {
        block13: {
            block12: {
                if (!this.rawString) break block12;
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        this.buffer.append(c);
                        break block13;
                    }
                    default: {
                        return false;
                    }
                }
            }
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.escapedUnicodeChar = 4096 * (c - 48);
                    break;
                }
                case 'A': 
                case 'a': {
                    this.escapedUnicodeChar = 40960;
                    break;
                }
                case 'B': 
                case 'b': {
                    this.escapedUnicodeChar = 45056;
                    break;
                }
                case 'C': 
                case 'c': {
                    this.escapedUnicodeChar = 49152;
                    break;
                }
                case 'D': 
                case 'd': {
                    this.escapedUnicodeChar = 53248;
                    break;
                }
                case 'E': 
                case 'e': {
                    this.escapedUnicodeChar = 57344;
                    break;
                }
                case 'F': 
                case 'f': {
                    this.escapedUnicodeChar = 61440;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean appendEscapedUnicodeChar2(char c) {
        block13: {
            block12: {
                if (!this.rawString) break block12;
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        this.buffer.append(c);
                        break block13;
                    }
                    default: {
                        return false;
                    }
                }
            }
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.escapedUnicodeChar += 256 * (c - 48);
                    break;
                }
                case 'A': 
                case 'a': {
                    this.escapedUnicodeChar += 2560;
                    break;
                }
                case 'B': 
                case 'b': {
                    this.escapedUnicodeChar += 2816;
                    break;
                }
                case 'C': 
                case 'c': {
                    this.escapedUnicodeChar += 3072;
                    break;
                }
                case 'D': 
                case 'd': {
                    this.escapedUnicodeChar += 3328;
                    break;
                }
                case 'E': 
                case 'e': {
                    this.escapedUnicodeChar += 3584;
                    break;
                }
                case 'F': 
                case 'f': {
                    this.escapedUnicodeChar += 3840;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean appendEscapedUnicodeChar3(char c) {
        block13: {
            block12: {
                if (!this.rawString) break block12;
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        this.buffer.append(c);
                        break block13;
                    }
                    default: {
                        return false;
                    }
                }
            }
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.escapedUnicodeChar += 16 * (c - 48);
                    break;
                }
                case 'A': 
                case 'a': {
                    this.escapedUnicodeChar += 160;
                    break;
                }
                case 'B': 
                case 'b': {
                    this.escapedUnicodeChar += 176;
                    break;
                }
                case 'C': 
                case 'c': {
                    this.escapedUnicodeChar += 192;
                    break;
                }
                case 'D': 
                case 'd': {
                    this.escapedUnicodeChar += 208;
                    break;
                }
                case 'E': 
                case 'e': {
                    this.escapedUnicodeChar += 224;
                    break;
                }
                case 'F': 
                case 'f': {
                    this.escapedUnicodeChar += 240;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean appendEscapedUnicodeChar4(char c) {
        block13: {
            block12: {
                if (!this.rawString) break block12;
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        this.buffer.append(c);
                        break block13;
                    }
                    default: {
                        return false;
                    }
                }
            }
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.escapedUnicodeChar += 1 * (c - 48);
                    break;
                }
                case 'A': 
                case 'a': {
                    this.escapedUnicodeChar += 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    this.escapedUnicodeChar += 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    this.escapedUnicodeChar += 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    this.escapedUnicodeChar += 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    this.escapedUnicodeChar += 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    this.escapedUnicodeChar += 15;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.buffer.append((char)this.escapedUnicodeChar);
        }
        return true;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.buffer.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }
}

