/*
 * Decompiled with CFR 0.152.
 */
package io.github.green4j.jelly;

import io.github.green4j.jelly.JsonBufferedWriter;

public class CharArrayWriter
implements JsonBufferedWriter {
    private final JsonBufferedWriter.Frame frame = new JsonBufferedWriter.Frame(){

        @Override
        public void setCharAt(int index, char c) {
            ((CharArrayWriter)CharArrayWriter.this).array[((CharArrayWriter)CharArrayWriter.this).frameStart + index] = c;
        }

        @Override
        public char charAt(int index) {
            return CharArrayWriter.this.array[CharArrayWriter.this.frameStart + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public int length() {
            return CharArrayWriter.this.frameSize;
        }

        @Override
        public String toString() {
            return new String(CharArrayWriter.this.array, CharArrayWriter.this.frameStart, CharArrayWriter.this.frameSize);
        }
    };
    private char[] array;
    private int start;
    private int length;
    private int frameStart;
    private int frameSize;

    public CharArrayWriter() {
    }

    public CharArrayWriter(int initialSize) {
        this(new char[initialSize]);
    }

    public CharArrayWriter(char[] array) {
        this(array, 0);
    }

    public CharArrayWriter(char[] array, int start) {
        this.set(array, start);
    }

    public void set(char[] array) {
        this.set(array, 0);
    }

    public void set(char[] array, int start) {
        assert (array.length > start);
        this.array = array;
        this.start = start;
        this.length = 0;
    }

    public char[] array() {
        return this.array;
    }

    public int start() {
        return this.start;
    }

    public int length() {
        return this.length;
    }

    public void clear() {
        this.length = 0;
    }

    @Override
    public JsonBufferedWriter.Frame append(int size) {
        assert (size > 0);
        this.makeSureRoomSize(size);
        this.frameStart = this.start + this.length;
        this.frameSize = size;
        this.length += size;
        return this.frame;
    }

    @Override
    public void append(char c) {
        assert (this.array != null);
        this.makeSureRoomSize(1);
        this.array[this.start + this.length] = c;
        ++this.length;
    }

    @Override
    public void append(CharSequence data) {
        this.append(data, 0, data.length());
    }

    @Override
    public void append(CharSequence data, int start, int len) {
        assert (this.array != null);
        this.makeSureRoomSize(len);
        for (int i = start; i < len; ++i) {
            this.array[start + this.length] = data.charAt(i);
        }
        this.length += len;
    }

    @Override
    public void flush() {
    }

    private void makeSureRoomSize(int roomSize) {
        int delta = this.array.length - (this.start + this.length + roomSize);
        if (delta < 0) {
            int newSize = Math.max(roomSize, this.array.length - this.start) << 1;
            char[] newArray = new char[newSize];
            System.arraycopy(this.array, this.start, newArray, 0, this.length);
            this.array = newArray;
            this.start = 0;
        }
    }

    public String toString() {
        if (this.array == null) {
            return "null";
        }
        return new String(this.array, this.start, this.length);
    }
}

