/*
 * Decompiled with CFR 0.152.
 */
package io.github.green4j.jelly;

import io.github.green4j.jelly.JsonBufferedWriter;
import io.github.green4j.jelly.JsonGenerator;

public final class AsciiByteArrayWriter
implements JsonBufferedWriter {
    private final JsonBufferedWriter.Frame frame = new JsonBufferedWriter.Frame(){

        @Override
        public void setCharAt(int index, char c) {
            assert (c > '\u001f' && c < '\u007f');
            ((AsciiByteArrayWriter)AsciiByteArrayWriter.this).array[((AsciiByteArrayWriter)AsciiByteArrayWriter.this).frameStart + index] = (byte)c;
        }

        @Override
        public char charAt(int index) {
            return (char)AsciiByteArrayWriter.this.array[AsciiByteArrayWriter.this.frameStart + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public int length() {
            return AsciiByteArrayWriter.this.frameSize;
        }

        @Override
        public String toString() {
            return new String(AsciiByteArrayWriter.this.array, AsciiByteArrayWriter.this.frameStart, AsciiByteArrayWriter.this.frameSize);
        }
    };
    private byte[] array;
    private int start;
    private int length;
    private int frameStart;
    private int frameSize;

    public AsciiByteArrayWriter() {
    }

    public AsciiByteArrayWriter(int initialSize) {
        this(new byte[initialSize]);
    }

    public AsciiByteArrayWriter(byte[] array) {
        this(array, 0);
    }

    public AsciiByteArrayWriter(byte[] array, int start) {
        this.set(array, start);
    }

    public void set(byte[] array) {
        this.set(array, 0);
    }

    public void set(byte[] array, int start) {
        assert (array.length > start);
        this.array = array;
        this.start = start;
        this.length = 0;
    }

    public byte[] array() {
        return this.array;
    }

    public int start() {
        return this.start;
    }

    public int length() {
        return this.length;
    }

    public void clear() {
        this.length = 0;
    }

    @Override
    public JsonBufferedWriter.Frame append(int size) {
        assert (size > 0);
        this.makeSureRoomSize(size);
        this.frameStart = this.start + this.length;
        this.frameSize = size;
        this.length += size;
        return this.frame;
    }

    @Override
    public void append(char c) {
        assert (this.array != null);
        assert (c > '\u001f');
        int charIndex = this.start + this.length;
        if (c < '\u007f') {
            this.makeSureRoomSize(1);
            ++this.length;
            this.array[charIndex] = (byte)c;
            return;
        }
        this.makeSureRoomSize(6);
        this.length += 6;
        this.array[charIndex++] = 92;
        this.array[charIndex++] = 117;
        if (c < '\u0800') {
            this.array[charIndex++] = 48;
            this.array[charIndex++] = 48;
            this.array[charIndex++] = (byte)JsonGenerator.HEX_DIGITS[c >>> 4 & 0xF];
            this.array[charIndex++] = (byte)JsonGenerator.HEX_DIGITS[c & 0xF];
            return;
        }
        if (c < '\u8000') {
            this.array[charIndex++] = 48;
            this.array[charIndex++] = (byte)JsonGenerator.HEX_DIGITS[c >>> 8 & 0xF];
            this.array[charIndex++] = (byte)JsonGenerator.HEX_DIGITS[c >>> 4 & 0xF];
            this.array[charIndex++] = (byte)JsonGenerator.HEX_DIGITS[c & 0xF];
            return;
        }
        this.array[charIndex++] = (byte)JsonGenerator.HEX_DIGITS[c >>> 12 & 0xF];
        this.array[charIndex++] = (byte)JsonGenerator.HEX_DIGITS[c >>> 8 & 0xF];
        this.array[charIndex++] = (byte)JsonGenerator.HEX_DIGITS[c >>> 4 & 0xF];
        this.array[charIndex++] = (byte)JsonGenerator.HEX_DIGITS[c & 0xF];
    }

    @Override
    public void append(CharSequence data) {
        this.append(data, 0, data.length());
    }

    @Override
    public void append(CharSequence data, int start, int len) {
        for (int i = start; i < len; ++i) {
            this.append(data.charAt(i));
        }
    }

    @Override
    public void flush() {
    }

    private void makeSureRoomSize(int roomSize) {
        int delta = this.array.length - (this.start + this.length + roomSize);
        if (delta < 0) {
            int newSize = Math.max(roomSize, this.array.length - this.start) << 1;
            byte[] newArray = new byte[newSize];
            System.arraycopy(this.array, this.start, newArray, 0, this.length);
            this.array = newArray;
            this.start = 0;
        }
    }

    public String toString() {
        if (this.array == null) {
            return "null";
        }
        return new String(this.array, this.start, this.length);
    }
}

